/*
 * @author zcc
 * @date   2020-07-01
 * 项目说明
 **/
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/server/entity/ProjectDetailsItem.dart';

class ProjectDetailsItemView extends StatelessWidget {
  Groups listData;

  ProjectDetailsItemView(this.listData);

  @override
  Widget build(BuildContext context) {
    List<Widget> tiles = [];
    for (var item in listData.attrs) {
      tiles.add(getItem(item));
    }
    var row = Row(
      children: <Widget>[
        Container(
          padding: EdgeInsets.only(top: 8.0, bottom: 8.0, left: 20),
          child: Text(
            listData.name,
            style: TextStyle(
              color: Color(0xFF000000),
              fontSize: 15.0,
            ),
          ),
        ),
        Column(
          children: tiles,
        )
      ],
    );
    return Container(
      margin: EdgeInsets.only(bottom: 5, left: 20),
      child: row,
    );
  }

  getItem(Attrs attrs) {
    var row = Container(
      margin: EdgeInsets.only(bottom: 25),
      child: Row(
        children: <Widget>[
          Text(
            attrs.attrName,
            style: TextStyle(
              color: Color(0xFF999999),
              fontSize: 13.0,
            ),
          ),
          Text(
            attrs.attrValue,
            style: TextStyle(
              color: Color(0xFF282828),
              fontSize: 14.0,
            ),
            maxLines: 1,
          ),
        ],
      ),
    );
    return Container(
      child: row,
    );
  }
}
