/*
 * @author zcc
 * @date   2020-07-01
 * 项目说明
 **/
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/commonModel/GMBase.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:gm_flutter/commonModel/util/PrintUtil.dart';

import '../../server/entity/ProjectDetailsItem.dart';

class ProjectDetailsModel extends BaseModel {
  LiveData<ProjectDetailsItem> liveData = LiveData();
  RxDispose rxDispose = RxDispose();

  void init() {
    ClueApiImpl.getInstance()
        .getProjectDetails(DioUtil.getInstance().getDio(), 123)
        .listen((event) {
          print(event);
          if (event.error == 0) {
            liveData.notifyView(event);
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
         PrintUtil.printBug(err);
    });
  }

  @override
  void dispose() {
    liveData.dispost();
    rxDispose.dispose();
  }
}
