import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/picker/base/BaseBottomPicker.dart';
import 'package:gm_flutter/ClueModel/server/entity/ConsultQuestionsBean.dart';
import 'package:gm_flutter/ClueModel/view/FiveStarView.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseUtil.dart';

import 'package:gm_flutter/ClueModel/page/mechanismBox/MechanismModel.dart';

class MechanismBox implements IBottomPicker {
  VoidCallback dismissCall;
  TextEditingController textController = TextEditingController();
  MechanismModel _model = new MechanismModel();

  @required
  final int plan_id;

  MechanismBox(this.plan_id) : super();

  @override
  initState(dismissCall, BuildContext context) {
    this.dismissCall = dismissCall;
    _model.getQuestions(plan_id);
  }

  Widget build(BuildContext context) {
    MediaQueryData mq = MediaQuery.of(context);
    double keyHeight = MediaQuery.of(context).viewInsets.bottom;
    return ClipRRect(
      borderRadius: BorderRadius.only(
          topLeft: Radius.circular(10.0), topRight: Radius.circular(10.0)),
      child: Container(
          width: mq.size.width,
          height: mq.size.height - 140,
          color: Colors.white,
          child: Column(
            mainAxisSize: MainAxisSize.max,
            children: <Widget>[
              title(mq),
              mechanismList(mq, keyHeight),
              bottomMessage()
            ],
          )),
    );
  }

  @override
  void dispose() {
    textController.dispose();
  }

  // 弹窗标题
  Widget title(mq) {
    return Container(
      margin: EdgeInsets.only(left: 20, right: 20),
      width: mq.size.width,
      decoration: BoxDecoration(
          border:
              Border(bottom: BorderSide(width: 1, color: Color(0xffE5E5E5)))),
      height: 50,
      child: Stack(
        alignment: Alignment.center,
        children: <Widget>[
          Container(
            child: Text(
              '请选择要咨询的机构',
              style: TextStyle(
                  color: Color(0xff282828),
                  fontSize: 17,
                  fontWeight: FontWeight.bold),
            ),
          ),
          Positioned(
              right: 0,
              top: 16.0,
              child: GestureDetector(
                onTap: () {
                  dismissCall();
                },
                child: Container(
                  width: 14,
                  height: 14,
                  child: Image.asset("assets/close-btn.png"),
                ),
              ))
        ],
      ),
    );
  }

  // 机构列表
  Widget mechanismList(mq, keyHeight) {
    return Container(
        height: mq.size.height - 140 - 96 - 50 - keyHeight,
        width: mq.size.width,
        padding: EdgeInsets.only(left: 15, right: 15),
        child: ListView.separated(
          itemCount: 100,
          itemBuilder: (BuildContext context, int index) {
            return HospitalItem(context, index);
          },
          separatorBuilder: (BuildContext context, int index) {
            return Divider(color: Color(0xffE5E5E5));
          },
        ));
  }

  // 机构卡片
  Widget HospitalItem(BuildContext context, int index) {
    return GestureDetector(
        onTap: () {},
        child: Container(
          height: 94.5,
          child: Stack(
            children: <Widget>[
              Positioned(
                  left: 0,
                  top: 35,
                  child: Container(
                    height: 17,
                    width: 17,
                    child: true
                        ? Image.asset("assets/icon-checked.png")
                        : Image.asset("assets/icon-check.png"),
                  )),
              Positioned(
                left: 32,
                top: 21,
                child: Container(
                  width: 45,
                  height: 45,
                  child: ClipOval(
                    child: CachedNetworkImage(
                      // imageUrl: cards.hospital.portrait,
                      imageUrl:
                          'https://img1.gamersky.com/image2019/07/20190725_ll_red_136_2/gamersky_07small_14_201972510258D0.jpg',
                    ),
                  ),
                ),
              ),
              Positioned(
                left: 89,
                top: 17.5,
                // child: baseText(cards.hospital.name, 15, Color(0xff333333),
                //     bold: true),
                child: baseText('22222', 15, Color(0xff333333), bold: true),
              ),
              Positioned(
                top: 42.5,
                right: 0,
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.end,
                  mainAxisSize: MainAxisSize.min,
                  children: <Widget>[
                    baseText("¥", 12, Color(0xffFF5963)),
                    baseText("${1}-${2}", 15, Color(0xffFF5963)),
                  ],
                ),
              ),
              Positioned(
                bottom: 21,
                left: 89,
                // child: baseText(cards.hospital.address, 12, Color(0xff666666)),
                child: baseText('dsssssssss', 12, Color(0xff666666)),
              ),
              Positioned(
                left: 89,
                top: 38.5,
                child: FiveStarView(2, 5),
              )
            ],
          ),
        ));
  }

  // 底部输入框部分
  Widget bottomMessage() {
    return Container(
        height: 96,
        color: Color(0xffF9F8FB),
        child: Column(
          children: <Widget>[
            Container(
                height: 25,
                width: double.maxFinite,
                margin: EdgeInsets.only(top: 12),
                child: Row(
                  mainAxisSize: MainAxisSize.max,
                  children: <Widget>[
                    Container(
                        margin: EdgeInsets.only(left: 15, right: 8),
                        height: 25,
                        child: Text(
                          '我想',
                          style: TextStyle(
                              height: 2,
                              color: Color(0xff666666),
                              fontSize: 12),
                        )),
                    StreamBuilder<ConsultQuestionsBean>(
                        stream: _model.questionsLive.stream,
                        initialData: _model.questionsLive.data,
                        builder: (c, data) {
                          List<String> questions = data.data.data.questions;
                          return ListView.builder(
                            scrollDirection: Axis.horizontal, //横向滚动
                            itemBuilder: (c, index) {
                              return GestureDetector(
                                onTap: () {
                                  textController.text += questions[index];
                                },
                                child: Container(
                                  height: 25,
                                  margin: EdgeInsets.only(right: 12),
                                  padding: EdgeInsets.only(left: 8, right: 8),
                                  decoration: BoxDecoration(
                                      border: Border.all(
                                          color: Color(0xffE5E5E5), width: 0.5),
                                      color: Color(0xffffffff),
                                      borderRadius: BorderRadius.circular(20)),
                                  child: Text(
                                    questions[index],
                                    style: TextStyle(
                                        fontSize: 12,
                                        color: Color(0xff666666),
                                        height: 1.8),
                                  ),
                                ),
                              );
                            },
                            itemCount: questions.length,
                          );
                        }),
                  ],
                )),
            Container(
                height: 35,
                width: double.maxFinite,
                margin: EdgeInsets.only(top: 12, left: 15, right: 15),
                decoration: BoxDecoration(
                    border: Border.all(color: Color(0xffE5E5E5), width: 0.5),
                    color: Color(0xffffffff),
                    borderRadius: BorderRadius.circular(35)),
                child: TextField(
                    controller: textController,
                    keyboardType: TextInputType.text,
                    textInputAction: TextInputAction.send,
                    onSubmitted: (txt) {},
                    style: TextStyle(fontSize: 12),
                    maxLines: 1,
                    decoration: InputDecoration(
                        contentPadding: EdgeInsets.only(
                            left: 16, top: 0, bottom: 12, right: 16),
                        hintText: '请输入您想了解的问题',
                        border: InputBorder.none)))
          ],
        ));
  }
}
