/*
 * @Author: zx 
 * @Date: 2020-06-30 17:40:43 
 * @Last Modified by: zx
 * @Last Modified time: 2020-07-01 22:11:20
 */

import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/gestures.dart';
import 'package:flutter/material.dart';
import 'package:gm_flutter/ClueModel/page/PlanCompareDetail/PlanCompareDetailModel.dart';
import 'package:gm_flutter/ClueModel/server/entity/PlanCompareDetail.dart';
import 'package:gm_flutter/ClueModel/view/FiveStarView.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/commonModel/base/BaseState.dart';

class PlanCompareDetailPage extends StatefulWidget {
  @override
    State<StatefulWidget> createState() => PlanCompareDetailPageState();
}

class PlanCompareDetailPageState extends BaseState<PlanCompareDetailPage> {
    PlanCompareDetailModel _model = new PlanCompareDetailModel();
    PageController pageController = new PageController();
    double screenWidth;
  List<Widget> viewList = new List();
@override
  void initState() {
    super.initState();
    pageController.addListener(() {
     
    });
    Groups groups;
    viewList.add(planNormalEffectiveAttrsView(groups));
    viewList.add(planNormalEffectiveAttrsView(groups));
    viewList.add(planNormalEffectiveAttrsView(groups));
  }

  @override
  void dispose() {
    _model.dispose();
    pageController.dispose();
    pageController.dispose();
    super.dispose();
  }

  @override
  Widget buildItem(BuildContext context) {
    screenWidth = MediaQuery.of(context).size.width;
    return Scaffold(
      appBar: baseAppBar(
          title: "对比详情",
          centerTitle: true,
          backClick: () {
            Navigator.pop(context);
          }),
      body: Container(
        child: 
        // planPopularityView()
        // planNormalEffectiveAttrsView()
        // setupHome([], []),
        reloadPage(),

      )
    );
  }

Widget reloadPage () {
  return StreamBuilder(
      stream: _model.detailLive.stream,
      initialData: PlanCompareDetail(),
      builder: (c, data) {
        PlanCompareDetail detail = data.data;
        if (detail == null || detail.data == null || detail.data.groups == null) {
          return loadingItem();
        }
        return setupHome(detail.data.plansInfo, detail.data.groups);
      },
    );
}

  Widget setupHome(List<PlansInfo> plansInfo, List<Groups> groups) {
    return Column(
      children: <Widget>[
        Expanded(
          child: Stack(
            children: <Widget>[
              head(plansInfo),
              Expanded (
                child: Container(
                  margin: EdgeInsets.fromLTRB(15, 105, 15, 0),
                  child: 
                  //  ListView.builder(
                  //         itemBuilder: (BuildContext context, int index) {
                  //           Groups group = groups[index];
                  //           switch (group.groupType) {
                  //             case 'hot':
                  //                 return planPopularityView(group);
                  //               break;
                  //                case 'normal_attrs':
                  //                   return planNormalEffectiveAttrsView(group);
                  //               break;
                  //                case 'effective_attrs':
                  //                   return planNormalEffectiveAttrsView(group);
                  //               break;
                  //             default:
                  //                   return planNormalEffectiveAttrsView(group);
                  //           }
                  //         },
                  //         itemCount: groups.length,
                  //       )
                  CustomScrollView(
                    slivers: <Widget>[
                          SliverList(
                            delegate: SliverChildBuilderDelegate(
                              (BuildContext context, int index) {
                                return viewList[index];
                              },
                              childCount: viewList.length,
                            ),
                          ),
                        ],
                      ),
                )
              ),
              
            ],
          ),
        )
      ],
    );
  }

  Widget head(List<PlansInfo> plansInfo) {
    PlansInfo plan;
    return Container(
      // key: keyTop,
      color: Colors.yellow,
      width: screenWidth,
      height: 105,
      alignment: Alignment.topLeft,
      margin: EdgeInsets.fromLTRB(9.5, 0, 9.5, 0),
      child: Row(children: <Widget>[
        // 根据 flex系数，分配剩余空间
        Expanded(
            flex:1,
            child: headItem(plan)
        ),
        Expanded(
            flex: 1,
            child: headItem(plan)
          )
        ] 
      
    ),
 );
  }

  Widget headItem(PlansInfo plan) {
    return  Container(
      child: Stack(
         children: <Widget>[
           Positioned(
             child: Container(
              margin: EdgeInsets.fromLTRB(5.5, 15, 5.5, 15),
              width: (screenWidth - 41) / 2.0,
              // child: Text('1111111'),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(7.0),
                image: 
                DecorationImage(
                    fit: BoxFit.cover,
                    image: NetworkImage(
                    "https://pic.igengmei.com/2018/09/11/1513/b7e825a4e4c1-w")
                    )
              )
              ),

           ),
           Positioned(
                left: 17.5,
                top: 31,
                child: baseText('11111', 15, Color(0xff333333),
                    bold: true),
              ),

              Positioned(
                left: 17.5,
                bottom: 31,
                child: baseText('￥￥￥￥￥￥￥￥￥￥', 14, Colors.red,
                    bold: true),
              ),

         ]
        
      )
    );
}
Widget titleView() {
    return Container(
      height: 81,
      width: screenWidth,
      color: Colors.cyan,
      margin: EdgeInsets.fromLTRB(0, 30, 0, 13),
      alignment: Alignment.topCenter,
      child: Container(
        child: baseText('基础属性', 21, Colors.black, bold: true),
      ),
      );
}

  Widget planPopularityView() {
    return Container(
      color: Colors.green,
      height: 265,
      child: Container (
        child: Column(
             children: <Widget>[
                titleView(),
                Row(
                  children: <Widget>[
                  Expanded(
                    flex:1,
                    child: planPopularityLeftItem()
                  ),
                  Expanded(
                    flex: 1,
                    child: planPopularityRightItem()
                  )
              ]   
            )
             ]
        )
      ),
      
    );
  }

    Widget planPopularityLeftItem() {
      return Container(
       color: Colors.red,
      //  height: 80,
       child: 
       Expanded(
        child: Stack(
         children: <Widget>[
           Positioned(
                right: 20,
                top: 12,
                child: baseText('99%', 21, Color(0xffF25874),
                    bold: true)
              ),

              Positioned(
                right: 20,
                top: 33,
                // bottom: 12,
                child: baseText('好评率', 12, Color(0xff666666),
                    bold: false),
              ),

              Positioned(
                right: 20,
                top: 55,
                // bottom: 12,
                child: FiveStarView(3,5),
              ),

               Positioned(
                right: 20,
                top: 98,
                bottom: 12,
                child: baseText('13679个', 21, Color(0xffF25874),
                    bold: true),
              ),

               Positioned(
                right: 20,
                top: 112,
                bottom: 12,
                child: baseText('销量', 12, Color(0xff666666),
                    bold: false),
              ),

               Positioned(
                right: 20,
                top: 132,
                bottom: 12,
                child: baseText('', 12, Color(0xff666666),
                    bold: false),
              ),
         ]
        
      )
       )
    );
}

    Widget planPopularityRightItem() {
      return Container(
      color: Colors.red,
      //  height: 80,
       child: 
       Expanded(
        child: Stack(
         children: <Widget>[
           Positioned(
                left: 20,
                top: 12,
                child: baseText('99%', 21, Color(0xffF25874),
                    bold: true)
              ),

              Positioned(
                left: 20,
                top: 33,
                // bottom: 12,
                child: baseText('好评率', 12, Color(0xff666666),
                    bold: false),
              ),

              Positioned(
                left: 20,
                top: 55,
                // bottom: 12,
                child: FiveStarView(3,5),
              ),

               Positioned(
                left: 20,
                top: 98,
                bottom: 12,
                child: baseText('13679个', 21, Color(0xffF25874),
                    bold: true),
              ),

               Positioned(
                left: 20,
                top: 112,
                bottom: 12,
                child: baseText('销量', 12, Color(0xff666666),
                    bold: false),
              ),

               Positioned(
                left: 20,
                top: 132,
                bottom: 12,
                child: baseText('', 12, Color(0xff666666),
                    bold: false),
              ),
         ]
        
      )
       )
    );
 }

  Widget planNormalEffectiveAttrsView(Groups groups) {
    return Container(
            color: Colors.green,
      child: Column(
        mainAxisAlignment: MainAxisAlignment.center,
         children: <Widget>[
            Expanded(
              child: Stack(
              children: <Widget>[
                titleView(),
                Expanded (
                  child: Container(
                    margin: EdgeInsets.fromLTRB(0, 68, 0, 0),
                    child: 
                        ListView.builder(
                          itemBuilder: (c, index) {
                            return planBaseAttrsView();
                          },
                          itemCount: 5,
                        )
                  )
                )
              ]
              )
             )
           
         ]
      )
    );

  }

  Widget planBaseAttrsView() {
    return Container(
       color: Colors.red,
       height: 80,
       child: Row(
         children: <Widget>[
            Expanded(
              flex:1,
              child: planBaseAttrsLeftView()
            ),
            Expanded(
              flex: 1,
              child: planBaseAttrsRightView()
            )
        ]          
      )
    );

  }

    Widget planBaseAttrsLeftView() {
      return Container(
       color: Colors.red,
       height: 80,
       child: Stack(
         children: <Widget>[
           Positioned(
                right: 20,
                top: 12,
                child: baseText('嘻嘻嘻嘻嘻嘻', 14, Color(0xff3FB5AF),
                    bold: true)
              ),

              Positioned(
                right: 20,
                // top: 12,
                bottom: 12,
                child: baseText('哈哈哈哈', 12, Color(0xff666666),
                    bold: false),
              ),
         ]
        
      )
    );
    }
    Widget planBaseAttrsRightView() {
      return Container(
       color: Colors.red,
       height: 80,
       child: Stack(
         children: <Widget>[
           Positioned(
                left: 20,
                top: 12,
                child: baseText('嘻嘻嘻嘻嘻嘻', 14, Color(0xffF25874),
                    bold: true)
              ),

              Positioned(
                left: 20,
                // top: 12,
                bottom: 12,
                child: baseText('哈哈哈哈', 12, Color(0xff666666),
                    bold: false),
              ),

         ]
        
      )
    );
    }
}