/*
 * @author lsy
 * @date   2020/6/29
 **/
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/ConsultQuestionsBean.dart';
import 'package:gm_flutter/commonModel/net/DioUtil.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:gm_flutter/commonModel/util/PrintUtil.dart';

class MechanismModel extends BaseModel {
  LiveData<ConsultQuestionsBean> questionsLive = LiveData();
  RxDispose rxDispose = RxDispose();

  getQuestions(int plan_id) {
    ClueApiImpl.getInstance()
        .getConsultQuestions(DioUtil.getInstance().getDio(), plan_id)
        .listen((event) {
          print('dadsadsa');
          print(event.data.questions.toList());
          print('dadsadsa');
          questionsLive.data = event;
        })
        .addToDispose(rxDispose)
        .onError((err) {
          PrintUtil.printBug(err);
        });
  }

  @override
  void dispose() {
    questionsLive.dispost();
  }
}
