/*
 * @author lsy
 * @date   2020-01-02
 **/
import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:flutter_common/flutter_common.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';

class MessageBarView extends StatelessWidget {
  final LiveData<int> topIndexLive;

  final LiveData<double> topScrollLive;

  final PageController pageController;

  bool leftShow = false;
  bool rightShow = false;

  MessageBarView({
    this.topIndexLive,
    this.topScrollLive,
    this.pageController,
  }) {}

  @override
  Widget build(BuildContext context) {
    return topView(context);
  }

  Widget topViewItem(String text, int index) {
    return StreamBuilder(
      stream: topIndexLive.stream,
      initialData: topIndexLive.data ?? 0.0,
      builder: (con, data) {
        return GestureDetector(
          behavior: HitTestBehavior.opaque,
          onTap: () {
//            pageController.jumpToPage(index);
            pageController.animateToPage(index,
                duration: Duration(milliseconds: 200), curve: Curves.ease);
          },
          child: Container(
            alignment: Alignment.bottomCenter,
            width: double.maxFinite,
            height: double.maxFinite,
            child: baseText(text, 16,
                data.data == index ? Color(0xff282828) : Color(0xffB5B5B5)),
          ),
        );
      },
    );
  }

  Widget topView(BuildContext context) {
    return Container(
      height: 49,
      width: double.maxFinite,
      child: Column(
        children: <Widget>[
          Expanded(
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Expanded(child: topViewItem("价格", 0)),
                Expanded(child: topViewItem("医院", 1)),
                Expanded(child: topViewItem("医生", 2)),
                Expanded(child: topViewItem("评价", 3)),
              ],
            ),
          ),
          Container(
            alignment: Alignment.topLeft,
            height: 8,
            margin: EdgeInsets.only(top: 4, bottom: 5),
            width: double.maxFinite,
            child: StreamBuilder(
              stream: topScrollLive.stream,
              initialData: topScrollLive.data ?? 0.0,
              builder: (con, data) {
                return Container(
                  margin: EdgeInsets.only(
                      left: MediaQuery.of(context).size.width / 12 +
                          4.5 +
                          data.data),
                  width: 22,
                  height: 3,
                  decoration: BoxDecoration(
                    borderRadius: new BorderRadius.circular((1.5)),
                    color: Color(0xff3FB5AF),
                  ),
                );
              },
            ),
          )
        ],
      ),
    );
  }
}
