import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/picker/base/BaseBottomPicker.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/ClueModel/page/levelOne/LevelOneListModel.dart';
import 'package:gm_flutter/ClueModel/server/entity/LevelOneFeedList.dart';
import 'package:gm_flutter/ClueModel/view/FiveStarView.dart';
import 'package:gm_flutter/commonModel/base/BaseComponent.dart';
import 'package:gm_flutter/ClueModel/page/mechanismBox/MechanismModel.dart';
import 'package:gm_flutter/commonModel/bean/Pair.dart';
import 'package:gm_flutter/main.mark.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';

class MechanismBox implements IBottomPicker {
  VoidCallback dismissCall;
  TextEditingController textController = TextEditingController();
  MechanismModel _model = new MechanismModel();
  List doctor_ids = new List();

  LevelOneListModel _levelModel = LevelOneListModel();
  RefreshController refreshController = RefreshController();

  Function(String str) refresh;

  @required
  final int plan_id;

  MechanismBox(this.plan_id) : super();

  @override
  initState(dismissCall, BuildContext context) {
    Map<String, dynamic> map = {
      "business_id": "level_two_plan_compare_deatil",
      "page_name": "",
      "referrer": "",
      "referrer_id": "",
      "referrer_link": [],
      "referrer_tab_name": "",
      "in": "",
      "out": "",
      "is_push": 1,
      "fake": 1,
      "is_first": 1
    };
    RouterCenterImpl().findMainRouter().buriedEvent("page_view", map);
    this.dismissCall = dismissCall;
    _model.getQuestions(plan_id);
    _levelModel.refreshView(true);
    refresh = (str) {
      _levelModel.stateLive.notifyView(LOADING);
      _levelModel.refreshView(true);
    };
  }

  Widget build(BuildContext context) {
    MediaQueryData mq = MediaQuery.of(context);
    double keyHeight = MediaQuery.of(context).viewInsets.bottom;
    return ClipRRect(
      borderRadius: BorderRadius.only(
          topLeft: Radius.circular(10.0), topRight: Radius.circular(10.0)),
      child: Container(
          width: mq.size.width,
          height: mq.size.height - 140,
          color: Colors.white,
          child: StreamBuilder(
            stream: _model.stateLive.stream,
            initialData: _model.stateLive.data ?? LOADING,
            builder: (c, data) {
              if (data.data == FAIL) {
                return errorItem(MediaQuery.of(context).size.width,
                    MediaQuery.of(context).size.height, () {
                  _model.getQuestions(plan_id);
                });
              }
              if (data.data == LOADING) {
                return loadingItem();
              }
              return setupHome(mq, keyHeight);
            },
          )),
    );
  }

  @override
  void dispose() {
    textController.dispose();
    refreshController.dispose();
    _levelModel.dispose();
    _model.dispose();
  }

  setupHome(mq, keyHeight) {
    return Column(
      mainAxisSize: MainAxisSize.max,
      children: <Widget>[
        title(mq),
        mechanismList(mq, keyHeight),
        bottomMessage()
      ],
    );
  }

  // 弹窗标题
  Widget title(mq) {
    return Container(
      margin: EdgeInsets.only(left: 20, right: 20),
      width: mq.size.width,
      decoration: BoxDecoration(
          border:
              Border(bottom: BorderSide(width: 1, color: Color(0xffE5E5E5)))),
      height: 50,
      child: Stack(
        alignment: Alignment.center,
        children: <Widget>[
          Container(
            child: Text(
              '请选择要咨询的机构',
              style: TextStyle(
                  color: Color(0xff282828),
                  fontSize: 17,
                  fontWeight: FontWeight.bold),
            ),
          ),
          Positioned(
              right: 0,
              top: 16.0,
              child: GestureDetector(
                onTap: () {
                  dismissCall();
                },
                child: Container(
                  width: 14,
                  height: 14,
                  child: Image.asset("assets/close-btn.png"),
                ),
              ))
        ],
      ),
    );
  }

  // 机构列表
  Widget mechanismList(mq, keyHeight) {
    return Container(
        height: mq.size.height - 140 - 96 - 50 - keyHeight,
        width: mq.size.width,
        padding: EdgeInsets.only(left: 15, right: 15),
        child: baseRefreshView(refreshController, () {}, null, null,
            customScrollView: CustomScrollView(
//          physics: NeverScrollableScrollPhysics(),
              physics: ClampingScrollPhysics(),
//          shrinkWrap: true,
              slivers: <Widget>[
//            SliverOverlapInjector(
//              handle: NestedScrollView.sliverOverlapAbsorberHandleFor(context),
//            ),
                StreamBuilder<List<Cards>>(
                  stream: _levelModel.cardsLive.stream,
                  initialData: _levelModel.cardsLive.data ?? [],
                  builder: (c, data) {
                    if (data.data.isEmpty && _levelModel.page > 1) {
                      refreshController.loadNoData();
                    } else {
                      refreshController.loadComplete();
                    }
                    return SliverList(
                      delegate: SliverChildBuilderDelegate(
                        (BuildContext context, int index) {
                          if (index == _levelModel.data.length) {
                            return Container(
                              height: 40,
                              color: Color(0xffF7F6FA),
                            );
                          }
                          if (_levelModel.data[index].cardType == 'hospital') {
                            Hospital hospital =
                                _levelModel.data[index].hospital;
                            return HospitalItem(hospital);
                          } else {
                            return Container();
                          }
                        },
                        childCount: _levelModel.data.length + 1,
                      ),
                    );
                  },
                ),
              ],
            ), onLoading: () {
          _levelModel.loadMore();
        }, pullDown: false, pullUp: true));
  }

  // 机构卡片
  Widget HospitalItem(Hospital hospital) {
    return GestureDetector(
        onTap: () {
          if (doctor_ids.indexOf(hospital.hosiptalId) != -1) {
            doctor_ids.remove(hospital.hosiptalId);
          } else {
            doctor_ids.add(hospital.hosiptalId);
          }
          hospital.isCheck = !hospital.isCheck;
          _levelModel.cardsLive.notifyView(_levelModel.cardsLive.data);
        },
        child: Container(
          height: 94.5,
          child: Stack(
            children: <Widget>[
              Positioned(
                  left: 0,
                  top: 35,
                  child: Container(
                    height: 17,
                    width: 17,
                    child: hospital.isCheck
                        ? Image.asset("assets/icon-checked.png")
                        : Image.asset("assets/icon-check.png"),
                  )),
              Positioned(
                left: 32,
                top: 21,
                child: Container(
                  width: 45,
                  height: 45,
                  child: ClipOval(
                    child: CachedNetworkImage(
                        // imageUrl: cards.hospital.portrait,
                        imageUrl: hospital.portrait),
                  ),
                ),
              ),
              Positioned(
                left: 89,
                top: 17.5,
                // child: baseText(cards.hospital.name, 15, Color(0xff333333),
                //     bold: true),
                child:
                    baseText(hospital.name, 15, Color(0xff333333), bold: true),
              ),
              Positioned(
                top: 42.5,
                right: 0,
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.end,
                  mainAxisSize: MainAxisSize.min,
                  children: <Widget>[
                    baseText("¥", 12, Color(0xffFF5963)),
                    baseText("${hospital.minPrice}-${hospital.maxPrice}", 15,
                        Color(0xffFF5963)),
                  ],
                ),
              ),
              Positioned(
                bottom: 21,
                left: 89,
                // child: baseText(cards.hospital.address, 12, Color(0xff666666)),
                child: baseText(hospital.address, 12, Color(0xff666666)),
              ),
              Positioned(
                left: 89,
                top: 38.5,
                child: FiveStarView(int.parse(hospital.star), 5),
              )
            ],
          ),
        ));
  }

  // 底部输入框部分
  Widget bottomMessage() {
    return Container(
        height: 96,
        color: Color(0xffF9F8FB),
        child: Column(
          children: <Widget>[
            Container(
                height: 25,
                width: double.maxFinite,
                margin: EdgeInsets.only(top: 12),
                child: Row(
                  children: <Widget>[
                    Container(
                        margin: EdgeInsets.only(left: 15, right: 8),
                        height: 25,
                        child: Text(
                          '我想',
                          style: TextStyle(
                              height: 2,
                              color: Color(0xff666666),
                              fontSize: 12),
                        )),
                    Expanded(
                      child: StreamBuilder<List<String>>(
                          stream: _model.questionsLive.stream,
                          initialData: _model.questionsLive.data ?? null,
                          builder: (c, e) {
                            if (e.data == null) {
                              return Container();
                            }
                            List<String> questions = e.data;
                            return ListView.builder(
                              scrollDirection: Axis.horizontal, //横向滚动
                              itemBuilder: (c, index) {
                                return GestureDetector(
                                  onTap: () {
                                    textController.text += questions[index];
                                  },
                                  child: Container(
                                    height: 25,
                                    margin: EdgeInsets.only(right: 12),
                                    padding: EdgeInsets.only(left: 8, right: 8),
                                    decoration: BoxDecoration(
                                        border: Border.all(
                                            color: Color(0xffE5E5E5),
                                            width: 0.5),
                                        color: Color(0xffffffff),
                                        borderRadius:
                                            BorderRadius.circular(20)),
                                    child: Text(
                                      questions[index],
                                      style: TextStyle(
                                          fontSize: 12,
                                          color: Color(0xff666666),
                                          height: 1.8),
                                    ),
                                  ),
                                );
                              },
                              itemCount: questions.length,
                            );
                          }),
                    )
                  ],
                )),
            Container(
                height: 35,
                width: double.maxFinite,
                margin: EdgeInsets.only(top: 12, left: 15, right: 15),
                decoration: BoxDecoration(
                    border: Border.all(color: Color(0xffE5E5E5), width: 0.5),
                    color: Color(0xffffffff),
                    borderRadius: BorderRadius.circular(35)),
                child: StreamBuilder(
                  stream: _model.messageLive.stream,
                  initialData: _model.messageLive.data ?? null,
                  builder: (context, snapshot) {
                    return TextField(
                        controller: textController,
                        keyboardType: TextInputType.text,
                        textInputAction: TextInputAction.send,
                        onSubmitted: (txt) {
                          if (doctor_ids.length > 3 || doctor_ids.length < 1) {
                            NativeToast.showNativeToast('请选择1-3个机构咨询');
                          } else {
                            if (txt != '') {
                              _model.sendMessage(doctor_ids, txt, plan_id, (i) {
                                if (i == 0) {
                                  dismissCall();
                                  textController.text = '';
                                  NativeToast.showNativeToast('消息已发送成功');
                                }
                              });
                            }
                          }
                        },
                        style: TextStyle(fontSize: 12),
                        maxLines: 1,
                        decoration: InputDecoration(
                            contentPadding: EdgeInsets.only(
                                left: 16, top: 0, bottom: 12, right: 16),
                            hintText: '请输入您想了解的问题',
                            border: InputBorder.none));
                  },
                ))
          ],
        ));
  }
}
