/*
 * @author lsy
 * @date   2020/5/8
 **/
import 'package:flutter/material.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:gm_flutter/main.mark.dart';

class NativeToast {
  static int lastTime;
  static String lastWorld;

  static void showNativeToast(String text) {
    showNativeToastWithTime(text, false);
  }

  static void showNativeToastWithTime(String text, bool long) {
    if (text == null) {
      text = "null";
    }
    if (lastTime != null &&
        lastWorld != null &&
        DateTime.now().millisecondsSinceEpoch - lastTime < 1000 &&
        lastWorld == text) {
      return;
    }
    lastTime = DateTime.now().millisecondsSinceEpoch;
    lastWorld = text;
    RouterCenterImpl().findMainRouter().showToast(text);
  }
}
