/*
 * @author lsy
 * @date   2020/6/29
 **/
import 'dart:math';

import 'package:flutter/material.dart';
import 'package:flutter_common/commonModel/live/BaseModel.dart';
import 'package:flutter_common/commonModel/live/LiveData.dart';
import 'package:flutter_common/commonModel/toast/NativeToast.dart';
import 'package:gm_flutter/ClueModel/server/api/ClueApi.serv.dart';
import 'package:gm_flutter/ClueModel/server/entity/ConsultQuestionsBean.dart';
import 'package:gm_flutter/commonModel/net/DioUtil.dart';
import 'package:gm_flutter/commonModel/rx/RxDispose.dart';
import 'package:gm_flutter/commonModel/util/PrintUtil.dart';

import '../../../commonModel/net/DioUtil.dart';
import '../../../commonModel/util/PrintUtil.dart';
import '../../server/api/ClueApi.serv.dart';

class MechanismModel extends BaseModel {
  LiveData<List<String>> questionsLive = LiveData();
  LiveData messageLive = LiveData();
  RxDispose rxDispose = RxDispose();

  getQuestions(int plan_id) {
    ClueApiImpl.getInstance()
        .getConsultQuestions(DioUtil.getInstance().getDio(), plan_id)
        .listen((event) {
          if (event.error == 0) {
            questionsLive.notifyView(event.data.questions);
          } else {
            NativeToast.showNativeToast(event.message);
            //TODO
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          PrintUtil.printBug(err);
        });
  }

  sendMessage(List<int> doctor_ids, String question, int plan_id) {
    ClueApiImpl.getInstance()
        .sendMessage(DioUtil.getInstance().getDio(), doctor_ids,
            question, plan_id)
        .listen((event) {
          print('11111');
          if (event.error == 0) {
            print('kljfjkfdhkhkdfsklkds');
            messageLive.notifyView(event.data.success);
          } else {
            NativeToast.showNativeToast(event.message);
          }
        })
        .addToDispose(rxDispose)
        .onError((err) {
          PrintUtil.printBug(err);
        });
  }

  @override
  void dispose() {
    questionsLive.dispost();
    rxDispose.dispose();
  }
}
