# coding=utf-8
# create by oldman at 2018/1/30
from django.db import models
from gm_types.artemis import ACCOUNT_STATUS, RECHANGE_STATUS, CASHBACK_AREA, CASHBACK_STATUS, ACCOUNTFLOW_OPERATE

from artemis.basemodel import BaseModel


class Account(BaseModel):
    class Meta:
        verbose_name = u'医生账号信息'
        app_label = 'account'

    doctor_id = models.CharField(max_length=100, verbose_name=u'医生ID', unique=True)
    rechange_amount = models.IntegerField(verbose_name='充值余额', default=0)
    cashback_amount = models.IntegerField(verbose_name='返现余额', default=0)
    status = models.IntegerField(verbose_name=u'账户状态', choices=ACCOUNT_STATUS, default=ACCOUNT_STATUS.NORMAL)
    is_accountuser = models.BooleanField(verbose_name=u'是否启用交易转广告', default=False)


class Rechange(BaseModel):
    class Meta:
        verbose_name = u'充值'
        app_label = 'account'

    account = models.ForeignKey(Account, verbose_name=u'账号')
    status = models.IntegerField(verbose_name=u'充值状态', choices=RECHANGE_STATUS)
    amount = models.IntegerField(verbose_name=u'充值金额', default=0)
    rechange_time = models.DateTimeField(verbose_name='审核通过时间(充值时间)', null=True)
    business_id = models.IntegerField(verbose_name=u'充值发起时商务user_id', null=True)


class CashBack(BaseModel):
    class Meta:
        verbose_name = u'返现'
        app_label = u'account'

    account = models.ForeignKey(Account, verbose_name=u'账号')
    area = models.IntegerField(verbose_name=u'大区', choices=CASHBACK_AREA)
    user_id = models.IntegerField(verbose_name=u'发起人ID')
    rechange_amount = models.IntegerField(verbose_name=u'充值金额')
    cashback_amount = models.IntegerField(verbose_name=u'返现金额')
    status = models.IntegerField(verbose_name=u'返现状态', choices=CASHBACK_STATUS)
    cashback_month = models.DateTimeField(verbose_name=u'返现月份')
    remark = models.CharField(max_length=500, verbose_name=u'返点备注', default='')


class AccountFlow(BaseModel):
    class Meta:
        verbose_name = '账号的流水表'
        app_label = 'account'

    # 记录账号的余额的变化
    account = models.ForeignKey(Account, verbose_name=u'账号信息')
    type = models.IntegerField(verbose_name=u'操作的类型', choices=ACCOUNTFLOW_OPERATE)
    operate_id = models.CharField(max_length=100,
                                  verbose_name=u'关联的ID')  # 关联的是Rechange/CashBack/Adorder/PvDeduct/MessageDeduct
    rechange_amount = models.IntegerField(verbose_name='账户之后的充值余额(包含当前操作)', default=0)
    cashback_amount = models.IntegerField(verbose_name='账户之后的返现余额(包含当前操作)', default=0)
    rechange = models.IntegerField(verbose_name='本次交易变化的充值金额 减了就是负值，加了就是正值', default=0)
    cashback = models.IntegerField(verbose_name='本次交易变化的返现金额 减了就是负值，加了就是正值', default=0)


class PvDeduct(BaseModel):
    class Meta:
        verbose_name = '页面浏览扣费'
        app_label = 'account'

    account = models.ForeignKey(Account, verbose_name=u'账号')
    pv_num = models.IntegerField(verbose_name=u'页面浏览量')
    amount = models.IntegerField(verbose_name=u'浏览量扣费')
    # 统计时间为实际产生uv的那一天，即为扣费时间前一天
    settle_time = models.DateField(verbose_name='统计时间')


class MessageDeduct(BaseModel):
    class Meta:
        verbose_name = '私信扣费'
        app_label = 'account'

    account = models.ForeignKey(Account, verbose_name=u'账号')
    message_num = models.IntegerField(verbose_name=u'私信条数')
    amount = models.IntegerField(verbose_name=u'私信扣费')
    # 统计时间为实际产生私信的那一天，即为扣费时间前一天
    settle_time = models.DateField(verbose_name='统计时间')


class AdOrder(BaseModel):
    class Meta:
        verbose_name = u'广告商品订单表'
        app_label = 'trade'

    id = models.CharField(max_length=12, verbose_name=u'订单号', primary_key=True)
    account = models.ForeignKey(Account, verbose_name=u'账号的操作记录', related_name=u'adorders')  # todo ondelete
    advertise = models.CharField(max_length=100, verbose_name=u'关联广告')  # todo ondelete

    # adtime = models.ForeignKey(AdTime, verbose_name=u'广告的时间ID', related_name=u'adorders', null=True)
    total_price = models.IntegerField(verbose_name='订单总价')
