# -*- coding:UTF-8 -*-
# @Time  : 2020/9/11 11:28
# @File  : func_from_redis_get_portrait.py
# @email : litao@igengmei.com
# @author : litao
import json

import redis

redis_client = redis.StrictRedis.from_url("redis://:ReDis!GmTx*0aN6@172.16.40.133:6379", decode_responses=True)
redis_client2 = redis.StrictRedis.from_url("redis://:ReDis!GmTx*0aN9@172.16.40.173:6379", decode_responses=True)
redis_client3 = redis.StrictRedis.from_url("redis://:ReDis!GmTx*0aN12@172.16.40.164:6379", decode_responses=True)
redis_client4 = redis.StrictRedis.from_url("redis://:XfkMCCdWDIU%ls$h@172.16.50.145:6379", decode_responses=True)


def get_user_portrait_tag3_redis_key(device_id):
    return "doris:user_portrait:tag3:device_id:" + str(device_id)


def get_user_portrait_tag3_from_redis(device_id, limit_score=0):
    def items_gt_score(d):
        new_d = dict(sorted(d.items(), key=lambda x: x[1], reverse=True))
        res = {tag: float(score) for tag, score in new_d.items() if float(score) >= limit_score}
        return list(res.keys())

    portrait_key = get_user_portrait_tag3_redis_key(device_id)
    if redis_client2.exists(portrait_key):
        user_portrait = json.loads(redis_client2.get(portrait_key))
        first_demands = items_gt_score(user_portrait.get("first_demands", {}))  # 一级诉求
        second_demands = items_gt_score(user_portrait.get("second_demands", {}))  # 二级诉求
        first_solutions = items_gt_score(user_portrait.get("first_solutions", {}))  # 一级方式
        second_solutions = items_gt_score(user_portrait.get("second_solutions", {}))  # 二级方式
        first_positions = items_gt_score(user_portrait.get("first_positions", {}))  # 一级部位
        second_positions = items_gt_score(user_portrait.get("second_positions", {}))
        projects = items_gt_score(user_portrait.get("projects", {}))  # 项目
        anecdote_tags = items_gt_score(user_portrait.get("anecdote_tags", {}))  # 八卦
        return {
            "first_demands": first_demands,
            "second_demands": second_demands,
            "first_solutions": first_solutions,
            "second_solutions": second_solutions,
            "first_positions": first_positions,
            "second_positions": second_positions,
            "projects": projects,
            "anecdote_tags": anecdote_tags
        }
    return {}


def user_portrait_scan_info():
    return_dict = {}
    try:
        round = 0
        all_count = 0
        empty_count = 0
        just_projects_count = 0
        keys = "doris:user_portrait:tag3:device_id:*"
        cur, results = redis_client2.scan(0, keys, 3000)
        while cur != 0:
            round += 1
            print("round: " + str(round))
            cur, results = redis_client2.scan(cur, keys, 3000)
            for key in results:
                key = key
                device_id = key.split(":")[-1]
                all_count += 1
                # print(key)
                # if user_portrait_is_empty(device_id):
                #     print(device_id)
                #     empty_count += 1

                # if user_portrait_just_projects(device_id):
                # print(device_id)
                # just_projects_count += 1

                # user_portrait_get_empty_candidates(device_id)
                try:
                    res_dic = get_user_portrait_tag3_from_redis(device_id)
                    yield res_dic
                except:
                    continue
                # for data_list in res_dic:
                #     for data in data_list:

        return return_dict
    except Exception as e:
        print(e)
        return {}


if __name__ == "__main__":
    scan_res = user_portrait_scan_info()
    for res in scan_res:
        print(res)