# -*- coding:UTF-8 -*-
# @Time  : 2020/9/9 10:07
# @File  : portary_div_exposure.py
# @email : litao@igengmei.com
# @author : litao
import datetime
import json
import traceback
import redis
import pymysql
from elasticsearch import Elasticsearch
from meta_base_code.utils.func_get_pv_card_id import get_card_id
import pandas as pd

redis_client = redis.StrictRedis.from_url("redis://:ReDis!GmTx*0aN6@172.16.40.133:6379", decode_responses=True)
redis_client2 = redis.StrictRedis.from_url("redis://:ReDis!GmTx*0aN9@172.16.40.173:6379", decode_responses=True)
redis_client3 = redis.StrictRedis.from_url("redis://:ReDis!GmTx*0aN12@172.16.40.164:6379", decode_responses=True)
redis_client4 = redis.StrictRedis.from_url("redis://:XfkMCCdWDIU%ls$h@172.16.50.145:6379", decode_responses=True)

es = Elasticsearch([
    {
        'host': '172.16.31.17',
        'port': 9200,
    }, {
        'host': '172.16.31.11',
        'port': 9200,
    }])


def user_portrait_scan_info():
    return_dict = {}
    try:
        round = 0
        all_count = 0
        empty_count = 0
        just_projects_count = 0
        keys = "doris:user_portrait:tag3:device_id:*"
        cur, results = redis_client2.scan(0, keys, 3000)
        while cur != 0:
            round += 1
            print("round: " + str(round))
            cur, results = redis_client2.scan(cur, keys, 3000)
            for key in results:
                key = key
                device_id = key.split(":")[-1]
                all_count += 1
                # print(key)
                # if user_portrait_is_empty(device_id):
                #     print(device_id)
                #     empty_count += 1

                # if user_portrait_just_projects(device_id):
                # print(device_id)
                # just_projects_count += 1

                # user_portrait_get_empty_candidates(device_id)
                try:
                    res_dic = get_user_portrait_tag3_from_redis(device_id)
                    # print(res_dic)
                    for data_type in res_dic:
                        for tag in res_dic[data_type]:
                            if tag == "眼窝":
                                print(return_dict.get(tag))
                            if return_dict.get(tag):
                                return_dict[tag] = (data_type, return_dict[tag][1] + 1)
                            else:
                                return_dict[tag] = (data_type, 1)
                except:
                    continue
                # for data_list in res_dic:
                #     for data in data_list:

        return return_dict
    except Exception as e:
        print(e)
        return {}


def get_user_portrait_tag3_redis_key(device_id):
    return "doris:user_portrait:tag3:device_id:" + str(device_id)


def get_user_portrait_tag3_from_redis(device_id, limit_score=0):
    def items_gt_score(d):
        new_d = dict(sorted(d.items(), key=lambda x: x[1], reverse=True))
        res = {tag: float(score) for tag, score in new_d.items() if float(score) >= limit_score}
        return list(res.keys())

    portrait_key = get_user_portrait_tag3_redis_key(device_id)
    if redis_client2.exists(portrait_key):
        user_portrait = json.loads(redis_client2.get(portrait_key))
        first_demands = items_gt_score(user_portrait.get("first_demands", {}))  # 一级诉求
        second_demands = items_gt_score(user_portrait.get("second_demands", {}))  # 二级诉求
        first_solutions = items_gt_score(user_portrait.get("first_solutions", {}))  # 一级方式
        second_solutions = items_gt_score(user_portrait.get("second_solutions", {}))  # 二级方式
        first_positions = items_gt_score(user_portrait.get("first_positions", {}))  # 一级部位
        second_positions = items_gt_score(user_portrait.get("second_positions", {}))
        projects = items_gt_score(user_portrait.get("projects", {}))  # 项目
        anecdote_tags = items_gt_score(user_portrait.get("anecdote_tags", {}))  # 八卦
        return {
            "first_demands": first_demands,
            "second_demands": second_demands,
            "first_solutions": first_solutions,
            "second_solutions": second_solutions,
            "first_positions": first_positions,
            "second_positions": second_positions,
            "projects": projects,
            "anecdote_tags": anecdote_tags
        }
    return {}


def get_channel_tags_info():
    """
    tag_ids: [416, 432, 421, 423, 275, 582]
    return:
    """
    sql = "SELECT name, tag_type from api_tag_3_0"
    results = get_data_by_mysql("172.16.30.141", 3306, "zx_str", "ZXueX58pStrage", "zhengxing", sql)
    first_demands_lst = []
    second_demands_lst = []
    first_solutions_lst = []
    second_solutions_lst = []
    first_positions_lst = []
    second_positions_lst = []
    projects_lst = []
    # channels_lst = []
    for i in results:
        name = i.get("name", "")
        tag_id = i.get("tag_type", -1)
        if tag_id == 1:
            projects_lst.append(name)
        elif tag_id == 21:
            first_positions_lst.append(name)
        elif tag_id == 22:
            second_positions_lst.append(name)
        elif tag_id == 19:
            first_demands_lst.append(name)
        elif tag_id == 20:
            second_demands_lst.append(name)
        elif tag_id == 18:
            first_solutions_lst.append(name)
        elif tag_id == 16:
            second_solutions_lst.append(name)
        # elif tag_id == 29:
        #     channels_lst.append(name)
    return {
        "first_demands": first_demands_lst,
        "second_demands": second_demands_lst,
        "first_solutions": first_solutions_lst,
        "second_solutions": second_solutions_lst,
        "first_positions": first_positions_lst,
        "second_positions": second_positions_lst,
        "projects": projects_lst,
        # "channels": channels_lst
    }


def get_device_num_from_es(word):
    results = es.search(
        index='gm-dbmw-device',
        doc_type='doc',
        timeout='10s',
        size=0,
        body={"aggs": {
            "NAME": {
                "nested": {"path": "projects"}, "aggs": {
                    "NAME1": {
                        "terms": {"field": "projects.name", "size": 10000}
                    }
                }

            }
        }
        }
    )
    tractate_content_num = results["hits"]["total"]
    return tractate_content_num


def get_es_article_num(tag_dict):
    # {tag_name:(answer_content_num, tractate_content_num, diary_content_num, total_num)}
    article_dict = {
        "first_demands": [],
        "second_demands": [],
        "first_solutions": [],
        "second_solutions": [],
        "first_positions": [],
        "second_positions": [],
        "projects": [],
    }
    for tag_type in tag_dict:
        for tag_name in tag_dict[tag_type]:
            if tag_type == "projects":
                temp_name = "tags_v3"
            elif tag_type == "first_positions":
                temp_name = "positions"
            else:
                temp_name = tag_name
            body = {
                "query": {
                    "bool": {
                        "minimum_should_match": 1,
                        "should": [],
                        "must": [
                            {
                                "term": {
                                    "is_online": True
                                }
                            }, {
                                "terms": {
                                    "content_level": [6, 5, 4, 3.5, 3]
                                }
                            }, {
                                "range": {
                                    "content_length": {
                                        "gte": 30
                                    }
                                }
                            }]

                    }
                }
            }
            body["query"]["bool"]["must"].append({"term": {temp_name: tag_name}})
            try:
                results = es.search(
                    index='gm-dbmw-answer-read',
                    doc_type='answer',
                    timeout='10s',
                    size=0,
                    body=body
                )
                answer_content_num = results["hits"]["total"]
            except:
                print("answer has no %s" % tag_type)
                answer_content_num = 0

            body = {
                "query": {
                    "bool": {
                        "minimum_should_match": 1,
                        "should": [],
                        "must": [{"term": {"is_online": True}},
                                 {"terms": {"content_level": [6, 5, 4, 3.5, 3]}}
                                 ]
                    }
                }
            }
            body["query"]["bool"]["must"].append({"term": {temp_name: tag_name}})
            # tractate
            try:
                results = es.search(
                    index='gm-dbmw-tractate-read',
                    doc_type='tractate',
                    timeout='10s',
                    size=0,
                    body=body
                )
                tractate_content_num = results["hits"]["total"]
            except:
                tractate_content_num = 0
                print("gm-dbmw-tractate-read has no %s" % tag_type)
            body = {
                "query": {
                    "bool": {
                        "minimum_should_match": 1,
                        "should": [],
                        "must": [{"term": {"is_online": True}}, {
                            "term": {
                                "has_cover": True
                            }
                        }, {"term": {
                            "is_sink": False
                        }
                                 }, {
                                     "term": {
                                         "has_after_cover": True
                                     }
                                 }, {
                                     "term": {
                                         "has_before_cover": True
                                     }
                                 }, {"range": {"content_level": {"gte": "3"}}},
                                 {
                                     "term": {
                                         "content_simi_bol_show": 0
                                     }
                                 }
                                 ]
                    }
                },
            }
            body["query"]["bool"]["must"].append({"term": {temp_name: tag_name}})
            ###diary 日记
            try:
                results = es.search(
                    index='gm-dbmw-diary-read',
                    doc_type='diary',
                    timeout='10s',
                    size=0,
                    body=body
                )
                diary_content_num = results["hits"]["total"]
            except:
                diary_content_num = 0
                print("gm-dbmw-diary-read has no %s" % tag_type)
            total_num = answer_content_num + tractate_content_num + diary_content_num
            data_dic = {tag_name: (answer_content_num, tractate_content_num, diary_content_num, total_num)}
            print(data_dic)
            article_dict[tag_type].append(data_dic)

    return article_dict


def get_data_by_mysql(host, port, user, passwd, db, sql):
    try:
        db = pymysql.connect(host=host, port=port, user=user, passwd=passwd, db=db,
                             cursorclass=pymysql.cursors.DictCursor)
        cursor = db.cursor()
        cursor.execute(sql)
        results = cursor.fetchall()
        db.close()
        return results
    except:
        print("error2_user_portrait", traceback.format_exc())
        return traceback.format_exc()


def from_id_get_tag(card_id_dict):
    index = ""
    doc_type = ""
    query_count = {
        "diary": {},
        "answer": {},
        "tractate": {}
    }
    for card_type in card_id_dict:
        if card_type == "diary":
            index = 'gm-dbmw-diary-read'
            doc_type = 'diary'
        elif card_type == "qa":
            index = 'gm-dbmw-answer-read'
            doc_type = 'answer'
        elif card_type == "user_post":
            index = 'gm-dbmw-tractate-read'
            doc_type = 'tractate'
        for card_id in card_id_dict[card_type]:
            res = es.get_source(index, doc_type, card_id)
            # print(res)
            first_demands = res.get("first_demands") if res.get("first_demands") else []
            second_demands = res.get("second_demands") if res.get("second_demands") else []
            first_solutions = res.get("first_solutions") if res.get("first_solutions") else []
            second_solutions = res.get("second_solutions") if res.get("second_solutions") else []
            first_positions = res.get("positions") if res.get("positions") else []
            second_positions = res.get("second_positions") if res.get("second_positions") else []
            projects = res.get("tags_v3") if res.get("tags_v3") else []
            word_count_list = first_demands + second_demands + first_solutions + second_solutions + first_positions + second_positions + projects
            for word in word_count_list:
                if word in query_count[doc_type]:
                    query_count[doc_type][word] = (doc_type, query_count[doc_type][word][1] + 1)
                else:
                    query_count[doc_type][word] = (doc_type, 1)
    return query_count


def save_data_to_csv(user_portrait_dict, word_count_exposure):
    all_data = [
        ("user_portrait", "tag_type", "user_portrait_count", "diary_exposure", "answer_exposure", "tractate_exposure")]
    for tag in user_portrait_dict:
        data_type = ""
        data_count = ""
        diary_exposure = ('diary', 0)
        answer_exposure = ('answer', 0)
        tractate_exposure = ('tractate', 0)
        user_portrait = user_portrait_dict.get(tag)
        if user_portrait:
            data_type, data_count = user_portrait
        if word_count_exposure["diary"].get(tag):
            diary_exposure = word_count_exposure["diary"].get(tag)
        if word_count_exposure["answer"].get(tag):
            answer_exposure = word_count_exposure["answer"].get(tag)
        if word_count_exposure["tractate"].get(tag):
            tractate_exposure = word_count_exposure["tractate"].get(tag)
        all_data.append((tag, data_type, data_count, diary_exposure[1], answer_exposure[1], tractate_exposure[1]))
        print(tag, all_data[-1])

    data = pd.DataFrame(all_data)
    s = datetime.datetime.now()
    ss = str(s)[0:19].replace(' ', '-').replace(':', '-')
    data.to_csv('data.csv', encoding='gb18030',
                # columns=columns
                )


def parse_data():
    demands_num = {}
    # 获取画像数
    # user_portrait_dict = {'溶脂针瘦全身': ('projects', 6), '牙齿': ('second_positions', 105601), '脱手脚毛': ('second_demands', 6680), '女性私处': ('first_positions', 38462), '润百颜玻尿酸': ('projects', 85), '玻尿酸': ('second_solutions', 318263), '脱全身毛发': ('second_demands', 20622), '吸脂瘦腰腹': ('projects', 21653), '激光祛眼袋': ('projects', 3383), '胸部假体取出': ('projects', 453), '豪门风云': ('anecdote_tags', 389), '贴面': ('second_solutions', 5817), '名媛上位史': ('anecdote_tags', 203), '普丽兰': ('projects', 4), '玻尿酸垫下巴': ('projects', 29873), '皮秒激光': ('projects', 25625), '吸脂瘦腰部': ('projects', 1584), '手背': ('second_positions', 6744), '眶隔脂肪释放': ('projects', 2622), '吸脂瘦小腿': ('projects', 1726), '高颜值推荐官': ('projects', 2), '隔空溶脂塑臀': ('projects', 3), '鼻头': ('second_positions', 69779), '激光祛黑眼圈': ('projects', 13978), '激光脱敏': ('projects', 407), '吸脂塑臀': ('projects', 8456), '激光祛皱': ('projects', 448), '隔空溶脂瘦腰腹': ('projects', 8), '超声溶脂瘦手臂': ('projects', 16), '隆鼻': ('second_demands', 179296), '激光溶脂瘦腰腹': ('projects', 721), '自体脂肪面部填充kyc': ('projects', 1), '美唇': ('first_demands', 10440), '面部去脂': ('second_demands', 6), '长鼻矫正': ('projects', 9), '毛发护理': ('second_solutions', 288), '雪梨': ('anecdote_tags', 37), '眼科': ('first_demands', 2429), '射频溶脂瘦手臂': ('projects', 700), '乳头缩小': ('projects', 18559), '冷冻溶脂瘦背': ('projects', 8), '美眼': ('first_demands', 257284), '提升手术': ('second_solutions', 403), '刘诗诗': ('anecdote_tags', 10), '微针美塑': ('projects', 45), '胶原蛋白水光': ('projects', 14), '基因检测': ('projects', 72), '鼻型': ('second_positions', 23), '眼泡': ('second_positions', 328), '私密部位': ('second_positions', 18535), '美容冠': ('second_solutions', 2963), '种植面膜': ('projects', 9), '祛静态纹': ('second_demands', 38), '悦升线': ('projects', 9), '隔空溶脂瘦肩': ('projects', 2), '隔空溶脂瘦小腿': ('projects', 5), '激光脱毛': ('second_solutions', 40610), '玻尿酸祛皱': ('projects', 20527), '祛抬头纹': ('second_demands', 107527), '红外光波': ('second_solutions', 1), '玻尿酸祛颈纹': ('projects', 2616), '半永久纹眉1': ('projects', 30), '硅胶垫鼻基底': ('projects', 3), 'G点注射': ('projects', 766), '祛脂肪粒': ('second_demands', 126), '上颚前突': ('projects', 27), '美白导入': ('projects', 41), '口腔检查': ('projects', 207), '丝丽动能素': ('projects', 51), '半飞秒激光术': ('projects', 92), '腰部': ('second_positions', 24921), '脱胡子': ('second_demands', 41), '眼圈': ('second_positions', 16926), '鼻梁': ('second_positions', 1522), '射频溶脂瘦小腿': ('projects', 114), '毛发': ('first_demands', 147868), '痣': ('second_positions', 1), '上颌': ('second_positions', 72), '激光': ('first_solutions', 31163), '颞发际': ('second_positions', 30578), '溶脂针祛双下巴': ('projects', 63), '隐形矫正': ('second_solutions', 31), '冷光美白': ('projects', 19110), '胸部修复1': ('projects', 67), '鼻尖延长': ('second_demands', 63830), 'FUT植发': ('projects', 48), '明星撕X': ('anecdote_tags', 3638), '腿形矫正': ('second_demands', 955), '玻尿酸垫鼻基底': ('projects', 8949), '激光洗眼线': ('projects', 57), '祛痘': ('second_demands', 121475), '嘴唇': ('second_positions', 4), '生私密毛发': ('second_demands', 23097), '涂氟': ('projects', 6), '自体脂肪': ('second_solutions', 157947), '后背': ('second_positions', 8744), '美脚': ('first_demands', 38), '果酸焕肤kyc': ('projects', 1), '外眼角修复': ('projects', 5), '塑臀': ('second_demands', 8595), '吸脂瘦腿': ('projects', 29062), '皮肤综合护理': ('projects', 25381), '牙齿抛光': ('second_solutions', 505), '祛皱注射': ('second_solutions', 45556), '男性私密': ('first_demands', 15271), '手术缩鼻头': ('projects', 211), '嘟嘟唇': ('projects', 1972), '鬓角': ('second_positions', 27604), '全激光手术': ('projects', 8), '光纤溶脂瘦手臂': ('projects', 2), 'HPV检查': ('projects', 257), '硅胶丰太阳穴': ('projects', 681), '面颊': ('second_positions', 16512), '额头缩小': ('projects', 271), '皮肤成型': ('second_solutions', 8), '吉娜': ('anecdote_tags', 23), '全身塑形': ('projects', 40063), '胶原蛋白': ('second_solutions', 5963), '祛痘印': ('second_demands', 74795), '肉毒素祛法令纹': ('projects', 323), '黄金微针': ('projects', 4811), '私密修复': ('projects', 6), '唇形': ('second_positions', 46654), '激光祛色素': ('projects', 5), '人工骨隆鼻': ('projects', 14010), '激光脱发际线': ('projects', 1282), '埋线提升': ('projects', 1390), '私密手术': ('second_solutions', 23455), '梨涡': ('second_positions', 124), '美迪塑': ('projects', 40), '沈梦辰': ('anecdote_tags', 3), '晚晚': ('anecdote_tags', 110), '吴昕': ('anecdote_tags', 8), '激光紧缩阴道': ('projects', 2613), '祛痘坑': ('second_demands', 38952), '膨体丰额头': ('projects', 59), '除皱针': ('projects', 45897), '丽芙莎EPT自体抗衰': ('projects', 4), '光子': ('second_solutions', 345), '纹绣': ('first_solutions', 19525), '丰面颊': ('second_demands', 11317), '嘴角': ('second_positions', 1845), '东国': ('projects', 4), '玻尿酸祛印第安纹': ('projects', 1), '综合': ('first_solutions', 66897), '皮肤暗沉': ('projects', 2684), '女性私密检查': ('projects', 1002), '衡力': ('projects', 178), '填充下颌缘': ('second_demands', 1), '脚骨矫正': ('projects', 31), '鼻中隔软骨垫鼻头': ('projects', 20), '冷冻溶脂瘦腿': ('projects', 15), '抗衰': ('first_demands', 149029), '牙龈': ('second_positions', 838), '身体护理': ('second_solutions', 9), '网红脸': ('second_demands', 302), '射频': ('second_solutions', 53578), '假体垫鼻基底': ('projects', 3925), '超声溶脂': ('projects', 5968), '镜片近视矫正': ('projects', 2), '综合祛皱': ('projects', 43784), '下颚提升': ('projects', 22), '菲洛嘉': ('projects', 19992), '超声提升': ('projects', 25868), '注射物取出': ('second_demands', 371), '激光脱全身毛发': ('projects', 24353), '脂肪胶': ('second_solutions', 23244), '消脂': ('first_solutions', 47974), '章子怡': ('anecdote_tags', 49), '水杨酸': ('second_solutions', 293), '盆底肌修复': ('projects', 7), '脱敏': ('second_demands', 426), '菲洛嘉水光针': ('projects', 136), '小腿神经阻断术': ('projects', 764), '胶原蛋白填充面部': ('projects', 1796), '种植牙': ('second_solutions', 2387), '玻尿酸填充面部': ('projects', 59528), '树脂贴面': ('projects', 888), '卧蚕修复': ('projects', 40), '武田美白针': ('projects', 15), '乳晕': ('second_positions', 2984), '私密健康': ('second_demands', 923), '自体脂肪填充卧蚕': ('projects', 531), '假体垫下巴': ('projects', 16749), '超声溶脂瘦腿': ('projects', 383), '变性手术': ('projects', 55), '瑞蓝3号': ('projects', 46), '曼特波隆鼻': ('projects', 4), '女性私密': ('first_demands', 37411), '外眼角': ('second_positions', 5942), '瘦大腿': ('second_demands', 38110), '调Q激光': ('second_solutions', 46366), '干细胞疗法': ('projects', 73), '双眼皮修复': ('projects', 11805), '美容仪': ('second_solutions', 17), '视力': ('second_positions', 1094), '自体脂肪填充阴唇': ('projects', 582), '瘦肩针': ('projects', 18602), '眼线': ('second_demands', 15303), '杏仁酸焕肤': ('projects', 39), '精华导入': ('projects', 1282), '月经不调': ('projects', 13), '开眼角': ('second_demands', 20924), '林珍娜': ('anecdote_tags', 8), '玻尿酸丰阴唇': ('projects', 574), '自体真皮隆鼻': ('projects', 27), '强脉冲激光': ('second_solutions', 49566), '晶体植入': ('projects', 177), '光纤溶脂瘦肩': ('projects', 2), '明星秘闻考古': ('anecdote_tags', 12471), '肉毒素': ('second_solutions', 134900), '离子束': ('second_solutions', 62), '颈部': ('first_positions', 19190), '胶原蛋白再生': ('second_solutions', 36), '婴儿针': ('projects', 439), '超声溶脂瘦背': ('projects', 5), '冷冻溶脂瘦腰部': ('projects', 332), '皓齿美白': ('projects', 22481), '冷冻溶脂': ('projects', 7503), '胸部提升': ('second_demands', 3933), '针灸': ('second_solutions', 54), '护肤': ('first_demands', 31644), '鼻部假体取出': ('projects', 3464), '牙齿侧舌矫正': ('projects', 9), '脱背毛': ('second_demands', 6666), '乳晕淡化': ('projects', 867), '自体脂肪丰下颌缘': ('projects', 3), '深层清洁': ('projects', 21), '胶原蛋白祛皱': ('projects', 1), '修眉': ('second_demands', 16560), '半永久纹发际线': ('projects', 7574), '玻尿酸垫眉弓': ('projects', 392), '植鬓角': ('projects', 2357), '埋线祛颈纹': ('projects', 326), '臀部假体': ('second_solutions', 640), '激光溶脂祛双下巴': ('projects', 264), '身体检查': ('projects', 2162), '填充苹果肌': ('second_demands', 9091), '牙齿金属矫正': ('projects', 181), '酒窝钉': ('second_solutions', 3), '激光脱臂毛': ('projects', 1602), '脚趾': ('second_positions', 10), '光纤溶脂': ('projects', 106564), '溶脂针瘦大腿': ('projects', 12), '耳部矫正': ('projects', 101), '古早网红': ('anecdote_tags', 2718), '脱腋毛': ('second_demands', 2254), '胶原蛋白丰面颊': ('projects', 164), '润月雅水光针': ('projects', 22), '超声溶脂瘦腰部': ('projects', 40), '手臂': ('second_positions', 6231), '瘦小腿': ('second_demands', 36643), '洗唇线': ('second_demands', 28464), '关晓彤': ('anecdote_tags', 7), '冷冻溶脂瘦小腿': ('projects', 332), '优立塑': ('projects', 239), '鼻部手术': ('second_solutions', 2), '生眉毛': ('second_demands', 985), '乳晕缩小': ('projects', 154), '紧致提升': ('second_demands', 58695), '祛脂手术': ('second_solutions', 20143), '阴唇整形': ('projects', 15718), '微笑唇': ('projects', 11325), '打耳洞': ('projects', 105), '隔空溶脂瘦大腿': ('projects', 4), '大腿': ('second_positions', 34471), '颧弓': ('second_positions', 17082), '杨超越': ('anecdote_tags', 1), '胎记': ('second_positions', 1), '自体脂肪垫鼻基底': ('projects', 871), '自体脂肪填充面部': ('projects', 56270), '中医': ('second_solutions', 1202), '自体脂肪面部填充': ('projects', 3937), '脸部': ('first_positions', 522087), '腋下': ('second_positions', 3659), '美提塑': ('projects', 1), 'PRP': ('second_solutions', 41), '祛疤': ('second_demands', 5911), '脸型填充': ('second_solutions', 1), '激光近视矫正': ('projects', 576), '吸脂瘦背': ('projects', 2117), '祛眼袋': ('second_demands', 167576), '阴茎美化': ('second_demands', 1124), 'FUE植发': ('projects', 127), '瘦脸': ('second_demands', 386319), '溶脂针瘦肩': ('projects', 1), '胶原蛋白填充苹果肌': ('projects', 25), '祛动态纹': ('second_demands', 261), '冷冻溶脂塑臀': ('projects', 4), '眼球': ('second_positions', 1562), '玻尿酸丰耳垂': ('projects', 38), '疤': ('second_positions', 3), '瘦腹部': ('second_demands', 3345), '玻尿酸丰臀': ('projects', 10), '果酸': ('second_solutions', 92471), '除螨': ('second_demands', 19), '隔空溶脂瘦背': ('projects', 2), '海薇玻尿酸': ('projects', 20), '缩鼻翼': ('second_demands', 87781), '注射祛眉间纹': ('projects', 110623), '私密检查': ('second_demands', 35), '额头': ('second_positions', 194877), '阴蒂整形': ('projects', 1946), '铂金瑞蓝': ('projects', 46), '刮痧': ('projects', 43), '八卦来了': ('anecdote_tags', 7401), '下巴前推': ('projects', 494), '瘦腿': ('second_demands', 62628), '埋线避孕': ('projects', 13), '小气泡': ('projects', 12341), '雷达电波': ('second_solutions', 1), '下颌内缩': ('projects', 13302), '瘦颈': ('second_demands', 114), '种植毛发': ('second_demands', 774), '洗眉': ('second_demands', 1037), '补牙': ('projects', 2963), '手术缩鼻翼': ('projects', 6417), '扩张器祛疤': ('projects', 7), '半永久纹眉': ('projects', 10075), '假体丰臀': ('projects', 681), '硅胶丰额头': ('projects', 345), '人中': ('second_positions', 6107), '肉毒素瘦下颌缘': ('projects', 3), '小切口手术提升': ('projects', 108), '祛黄褐斑': ('second_demands', 297), '祛面部细纹': ('second_demands', 52), '真皮填充卧蚕': ('projects', 118), '牙齿舌侧矫正': ('second_solutions', 492), '防脱发': ('projects', 13), 'HPV': ('second_demands', 221), '王菲': ('anecdote_tags', 1), '埋线瘦身': ('projects', 1242), '隔空溶脂瘦腰部': ('projects', 1), '激光祛脂肪粒': ('projects', 120), '远视矫正': ('projects', 3), '祛斑kyc': ('projects', 1), '胶原蛋白填充泪沟': ('projects', 1311), '肉毒素祛动态纹': ('projects', 434), '阴道缩紧': ('second_demands', 27836), '双眼皮kyc': ('projects', 1), '祛胎记': ('second_demands', 71), '激光祛痣': ('projects', 11508), 'E光嫩肤': ('projects', 14), '自体骨': ('second_solutions', 91648), '白瓷娃娃': ('projects', 3453), '硅胶垫眉弓': ('projects', 474), '视力检查': ('projects', 132), '童颜针': ('projects', 590), '祛眉间纹': ('second_demands', 123373), '膨体垫鼻基底': ('projects', 123), '秀智': ('anecdote_tags', 1), '脱唇毛': ('second_demands', 1896), '中医按摩': ('projects', 1), '嫩唇': ('second_demands', 2741), '玻尿酸祛静态纹': ('projects', 36), '祛黑眼圈': ('second_demands', 64246), '男性乳房肥大矫正': ('projects', 14), '种痣': ('second_demands', 8), '护理': ('first_solutions', 1597), '蔡依林': ('anecdote_tags', 164), '水光针': ('projects', 59123), '玻尿酸填充卧蚕': ('projects', 2026), '垫眉弓': ('second_demands', 2004), '自体脂肪祛法令纹': ('projects', 316), '乔欣': ('anecdote_tags', 16), '美鼻': ('first_demands', 168576), '脱敏修复': ('projects', 1), '二氧化锆全瓷牙': ('projects', 16), '全身': ('first_positions', 76), '埋线瘦腰腹': ('projects', 488), '脂肪释放': ('second_solutions', 1), '假体丰太阳穴': ('projects', 6443), '人中缩短': ('projects', 11280), '激光溶脂瘦全身': ('projects', 51), '注射祛腋臭': ('projects', 1012), '面膜': ('projects', 1583), '卧蚕': ('second_positions', 3064), '手术修复': ('second_solutions', 3), '赵丽颖': ('anecdote_tags', 581), '腹部拉皮': ('projects', 12), '吸脂瘦全身': ('projects', 103455), '鹰钩鼻矫正': ('projects', 23), '牙髓炎': ('projects', 41), '宽下巴矫正': ('projects', 3), '生发际线': ('second_demands', 10101), '铒激光': ('second_solutions', 14), '处女膜': ('second_demands', 10784), '神经手术': ('second_solutions', 736), '无针线雕': ('projects', 85), '黄金微针祛妊娠纹': ('projects', 1357), '健康调理': ('second_demands', 891), '范冰冰': ('anecdote_tags', 372), '美白贴片': ('projects', 1), '瑞蓝5号': ('projects', 46), '埋线': ('second_solutions', 128108), '超声溶脂塑臀': ('projects', 3), '乳牙': ('second_demands', 64273), '眼部': ('first_positions', 334454), '内眦赘皮矫正': ('projects', 494), '斜视矫正': ('projects', 11), 'M唇1': ('projects', 1), '鼻翼': ('second_positions', 77741), '远视': ('second_demands', 3), '结膜炎': ('second_demands', 36), '备孕': ('second_demands', 16), '手术祛副乳': ('projects', 600), '乳头美化': ('second_demands', 628), '冷冻溶脂瘦腰腹': ('projects', 11), '个性定制': ('second_solutions', 104), '鼻孔': ('second_positions', 1603), '精准嫩肤': ('second_solutions', 55), '泫雅': ('anecdote_tags', 5), '新手精选': ('projects', 61), '疫苗': ('second_solutions', 106), '隔空溶脂瘦手臂': ('projects', 6), '埋线祛皱': ('projects', 4566), '太阳穴': ('second_positions', 20175), '丰手': ('second_demands', 2), '凸嘴': ('second_demands', 429), '乳腺检查': ('second_demands', 16), '双眼皮': ('second_demands', 142569), '水光注射': ('second_solutions', 57160), '臂部': ('first_positions', 6233), '自体脂肪隆胸': ('projects', 65876), '闫妮': ('anecdote_tags', 1), '程潇': ('anecdote_tags', 1), '植胸毛': ('projects', 1), '吸脂修复1': ('projects', 1531), '冷冻溶脂瘦腹部': ('projects', 335), '杨幂': ('anecdote_tags', 908), '激光祛斑': ('projects', 31363), '角膜炎': ('second_demands', 11), '港星': ('anecdote_tags', 14), '鼻部缩短': ('second_demands', 2976), '玻尿酸溶解酶': ('projects', 866), '锁骨': ('second_positions', 181), '肉毒素颏肌放松': ('projects', 12), '胶原培植': ('projects', 10), '瘦脸针': ('projects', 324872), '软骨': ('second_solutions', 5), '阴茎延长': ('projects', 406), '胶原蛋白丰太阳穴': ('projects', 142), '皮下组织': ('first_positions', 63), '植发kyc': ('projects', 1), '微针水光': ('projects', 9683), '包皮手术': ('projects', 239), '射频溶脂祛双下巴': ('projects', 59), '吸脂祛副乳': ('projects', 658), '私处手术': ('second_solutions', 1), '沈月': ('anecdote_tags', 53), '调理': ('first_solutions', 4947), '眼科治疗': ('first_solutions', 811), '明星出轨': ('anecdote_tags', 2044), '缩鼻头': ('second_demands', 10541), '杏仁酸': ('second_solutions', 33), '林志玲': ('anecdote_tags', 24), '脸形': ('first_demands', 511690), '皮肤': ('first_positions', 244484), '无创疤痕修复': ('projects', 45), '缩咬肌': ('second_demands', 312708), '超声溶脂瘦肩': ('projects', 7), '泪腺脱垂': ('second_demands', 12), '吸脂修复': ('second_demands', 111806), '祛鼻背纹': ('second_demands', 36), '假体隆胸': ('projects', 31143), '生育': ('second_demands', 15), '爱贝芙': ('second_solutions', 36), '微针': ('second_solutions', 16949), '激光脱私处毛发': ('projects', 3102), '汗腺': ('second_positions', 22), '健康': ('first_solutions', 1304), '祛眼纹': ('second_demands', 124793), '手术': ('first_solutions', 12851), '艾莉薇': ('projects', 43), '激光祛妊娠纹': ('projects', 853), '小棕瓶美白': ('projects', 1), '耳软骨垫鼻头': ('projects', 239), '复颜针': ('projects', 1), '眼袋': ('second_positions', 133932), '鼻小柱缩短': ('projects', 2), '洗牙': ('second_solutions', 73301), '注射祛鱼尾纹': ('projects', 111273), '射频溶脂祛副乳': ('projects', 1), '全飞秒': ('projects', 438), '内窥镜手术提升': ('projects', 19), '生胸毛': ('second_demands', 1), '热拉提': ('projects', 10011), '网红照骗': ('anecdote_tags', 699), '脱臂毛': ('second_demands', 843), 'Glutax美白针': ('projects', 13), '海藻针': ('second_solutions', 11), '色素': ('second_positions', 2), '产后修复': ('projects', 496), '超声溶脂祛眼袋': ('projects', 19425), '熊猫针祛黑眼圈': ('projects', 127), '激光祛红血丝': ('projects', 9907), '激光溶脂瘦肩': ('projects', 364), '唇腭裂': ('second_demands', 30612), '激光祛腋臭': ('projects', 64), '瘦脸针kyc': ('projects', 1), '微针祛黑眼圈': ('projects', 1006), '牙齿清洁': ('second_demands', 57850), '男变女': ('second_demands', 55), '耳部': ('first_positions', 1656), '腿形': ('second_positions', 52113), '臀部': ('first_positions', 16388), '身高': ('first_demands', 28), '两颚': ('second_positions', 7), '水氧': ('second_solutions', 2927), '综合除皱': ('projects', 2), '超声溶脂瘦全身': ('projects', 51), '盆底修复': ('projects', 3641), '手术祛露龈笑': ('projects', 3), '脚掌': ('second_positions', 7332), '激光面部提升': ('projects', 3), '山根': ('second_positions', 1182), '隔空溶脂瘦全身': ('projects', 51), '美腿': ('first_demands', 238), '膨体垫下巴': ('projects', 1687), '头皮护理': ('second_demands', 15), '阴道修复': ('second_demands', 6), '切痣': ('projects', 81), '肩膀': ('second_positions', 19106), '自体脂肪丰额头': ('projects', 13402), 'C10祛斑': ('projects', 257), '硅胶垫下巴': ('projects', 4625), '射频溶脂': ('projects', 8441), '雀斑': ('second_positions', 1), '网红八一八': ('anecdote_tags', 4244), '全飞秒激光术': ('projects', 275), '半永久': ('second_solutions', 21548), '吸脂瘦肩': ('projects', 989), '半飞秒': ('projects', 174), '上眼睑提肌': ('projects', 7656), '纹身': ('first_demands', 994), '镭射净肤': ('projects', 60), '检查': ('first_solutions', 2918), '妇科': ('first_demands', 107), '瑞蓝4号': ('projects', 46), '硬骨矫正': ('second_solutions', 180624), '胸部手术': ('second_solutions', 128), '耳部美化': ('second_demands', 25), '美臀': ('first_demands', 17206), '美白嫩肤': ('second_demands', 5), '徐圣恩': ('projects', 1), '动氧溶脂祛副乳': ('projects', 1), '小腿': ('second_positions', 3958), '脚趾整形': ('second_demands', 14), '自体脂肪填充泪沟': ('projects', 2456), '乳房再造': ('projects', 904), '唇部美化': ('projects', 3796), '私密紧致': ('second_demands', 2341), '美黑': ('second_demands', 33), '眼袋修复': ('projects', 1074), '祛颈纹': ('second_demands', 17947), '射频溶脂瘦腿': ('projects', 243), '缩窄下巴': ('second_demands', 61), '光纤溶脂祛眼袋': ('projects', 102674), '面部轮廓': ('second_demands', 12141), '网红换头史': ('anecdote_tags', 6603), '散光': ('second_demands', 3), '伊婉V': ('projects', 135), '祛颊脂垫': ('projects', 6556), '眉部': ('first_positions', 9978), '身体其他': ('first_positions', 1763), '下颚': ('second_positions', 905), '美妆护肤': ('projects', 2), '王一博': ('anecdote_tags', 642), '硅胶丰臀': ('projects', 1), '臀部整形kyc': ('projects', 2), '黑脸娃娃': ('projects', 1930), '玻尿酸修复': ('second_demands', 768), 'PRP自体脂肪填充': ('projects', 54), '值得购买': ('projects', 4), '缩人中': ('projects', 1), '光子嫩肤': ('projects', 45543), '流产': ('second_demands', 14), '祛黑头': ('second_demands', 71019), '厚唇改薄': ('projects', 6543), '假体取出': ('second_demands', 3846), '干细胞': ('second_solutions', 380), '下巴': ('second_positions', 205340), '玻尿酸祛黑眼圈': ('projects', 3824), '牙齿kyc': ('projects', 2), '牙齿半隐形矫正': ('second_solutions', 1380), '明星上位史': ('anecdote_tags', 2676), '美白仓': ('projects', 131), '唇色': ('second_positions', 1825), '手术延长鼻小柱': ('projects', 39), '鼻综合': ('projects', 106450), '半永久纹身': ('projects', 11), '超体隆鼻': ('projects', 283), '口腔': ('first_demands', 224211), '面部假体': ('second_solutions', 22764), '隔空溶脂瘦腿': ('projects', 13), '乳房缩小': ('projects', 308), '玻尿酸丰唇': ('projects', 11169), '爱芙莱': ('projects', 22), '鼻中隔延长': ('second_demands', 235), '补水': ('second_demands', 104572), '腹壁成形术': ('projects', 227), '酒窝成形': ('projects', 1280), '臀部整形': ('projects', 2474), '植眉': ('projects', 997), '射频溶脂瘦脸': ('projects', 63), '射频溶脂瘦全身': ('projects', 56), '美胸': ('first_demands', 118180), '胶原蛋白丰阴唇': ('projects', 573), '乳房提升': ('projects', 148), '埋线缩鼻翼': ('projects', 67921), '微晶瓷': ('second_solutions', 502), '眉弓': ('second_positions', 2142), '溶脂针瘦手臂': ('projects', 1), '周冬雨': ('anecdote_tags', 401), '假体隆鼻': ('projects', 25975), '发质护理': ('projects', 259), '手指整形': ('second_demands', 41), '注射祛动态纹': ('projects', 49), '小臂': ('second_positions', 5816), '歪鼻矫正': ('projects', 48), '近视': ('second_demands', 1094), '美人尖': ('second_positions', 23661), '唇珠': ('second_positions', 698), '微针美肤': ('projects', 5), '鼻小柱矫正': ('second_demands', 5498), '唇腭裂1': ('projects', 205), '王子文': ('anecdote_tags', 52), '化学剥脱': ('second_solutions', 32), '拔牙': ('projects', 1305), '异体骨隆鼻': ('projects', 66), '85大花秘史': ('anecdote_tags', 3162), '拉皮手术提升': ('projects', 224), '腿部': ('first_positions', 45925), '黄金微雕': ('projects', 840), '驼峰鼻矫正': ('projects', 44), '瓷贴面': ('projects', 5231), '内吸祛眼袋': ('projects', 18327), '美白针': ('projects', 104746), '牙齿矫正': ('second_demands', 50236), '瘦身': ('first_demands', 52340), '美白': ('second_demands', 298262), '肩部': ('first_positions', 19256), '胸型': ('second_positions', 22), '祛法令纹': ('second_demands', 25650), '鼻部修复1': ('projects', 1), '贵金属烤瓷牙': ('projects', 79), '面部线雕': ('projects', 28856), '缩阴道激光': ('second_solutions', 2734), '牙齿种植': ('second_demands', 2826), '鹿晗': ('anecdote_tags', 85), '阴唇': ('second_positions', 15216), '眼角提升': ('second_demands', 291), '牙齿陶瓷矫正': ('projects', 24), '生睫毛': ('second_demands', 654), '下颌缘提升': ('second_demands', 17918), '缩短眼距': ('second_demands', 1), '射频溶脂瘦腰腹': ('projects', 996), '娄艺潇': ('anecdote_tags', 26), '自体脂肪丰太阳穴': ('projects', 6798), '艾灸': ('projects', 9), '自体软骨垫鼻尖': ('projects', 68297), '私密护理': ('second_solutions', 3483), '弱视': ('second_demands', 1), '阴道': ('second_positions', 1228), '组团磕八卦': ('anecdote_tags', 8007), '植发际线': ('projects', 8516), '鼻形矫正': ('second_demands', 10222), '祛露龈笑': ('second_demands', 1), '备孕检查': ('projects', 1), '瑞蓝1号': ('projects', 46), '超声溶脂瘦腰腹': ('projects', 270), '腿部加长': ('second_demands', 28), '半永久套餐': ('projects', 8761), '美白注射': ('second_solutions', 102011), '鞠婧祎': ('anecdote_tags', 2), '生长因子': ('projects', 311), '祛黑头1': ('projects', 2), '痘印': ('second_positions', 1), '玻尿酸隆鼻': ('projects', 15968), '下颌角整形': ('projects', 9291), '龋齿': ('projects', 187), '溶脂注射': ('second_solutions', 1401), '胶原蛋白隆胸': ('projects', 191), '丰下颌缘': ('second_demands', 1), '牙齿护理': ('second_demands', 731), '毛囊检测': ('projects', 72), '埋线隆胸': ('projects', 24015), '眼眶': ('second_positions', 91), '翘睫': ('second_demands', 825), '俞飞鸿': ('anecdote_tags', 2), '自体脂肪祛颈纹': ('projects', 15960), '超声溶脂瘦大腿': ('projects', 45), '生殖系统': ('second_positions', 300), '小V脸': ('projects', 11591), '性快感': ('second_demands', 754), '光纤溶脂瘦腿': ('projects', 14), '胶原蛋白祛黑眼圈': ('projects', 2671), '毛晓彤': ('anecdote_tags', 12), '唇部综合': ('projects', 103), '激光溶脂瘦脸': ('projects', 1308), '脂肪胶隆胸': ('projects', 23758), '祛双下巴': ('second_demands', 16647), '阴茎增粗': ('projects', 1023), '软骨垫鼻基底': ('projects', 2022), '酒窝': ('second_demands', 2821), '胸部注射物取出': ('projects', 289), '自体脂肪丰唇': ('projects', 2162), '下颌缘': ('second_positions', 10182), '微晶瓷隆鼻': ('projects', 487), '丰唇': ('second_demands', 36141), '阴茎': ('second_positions', 1212), '动氧溶脂瘦肩': ('projects', 2), '手术祛黑眼圈': ('projects', 9), 'SMAS除皱术': ('projects', 5), '自体真皮': ('second_solutions', 153), '缩额头': ('second_demands', 11), '红蓝光祛痘': ('projects', 10941), '下巴下颌': ('projects', 2), '欧阳娜娜': ('anecdote_tags', 35), '祛副乳': ('second_demands', 787), '射频溶脂瘦颈部': ('projects', 1), '发际线': ('second_positions', 36493), '光纤溶脂祛双下巴': ('projects', 59), '胶原蛋白注射': ('projects', 206), '热点课代表': ('anecdote_tags', 581), '肉毒素治疗多汗': ('projects', 26), '垫下巴': ('second_demands', 39785), '阴唇漂红': ('projects', 3238), '咬肌切除': ('projects', 125), '面部溶脂针': ('projects', 1401), 'AI测试': ('second_demands', 37), '控油': ('second_demands', 91714), '冷冻溶脂瘦肩': ('projects', 10), '按摩': ('second_solutions', 903), '射频美肤': ('projects', 92), '外眼角提升': ('projects', 27), '激光脱腋毛': ('projects', 3116), '聚能震波吸脂': ('projects', 1), '口腔溃疡': ('projects', 34102), '拔罐': ('projects', 58), '景甜': ('anecdote_tags', 48), '吸脂瘦下颌缘': ('projects', 9406), '颏肌放松': ('second_demands', 83), '鼻基底': ('second_positions', 16194), '动氧溶脂瘦手臂': ('projects', 1), '吸脂祛眼袋': ('projects', 110045), '皮肤护理': ('second_demands', 27384), '医学审美干货': ('anecdote_tags', 127), '王思聪': ('anecdote_tags', 113), '玻尿酸填充苹果肌': ('projects', 3819), '祛妊娠纹': ('second_demands', 1697), '超声溶脂瘦小腿': ('projects', 42), '自体脂肪填充修复': ('projects', 19428), '射频紧肤': ('projects', 65), '射频溶脂瘦腹部': ('projects', 103), '智齿': ('second_demands', 1568), '乳头再造': ('projects', 201), '注射缩鼻头': ('projects', 63), '胡子': ('second_positions', 2227), '齿科治疗': ('first_solutions', 9415), '埋线双眼皮': ('projects', 17460), '光纤溶脂瘦全身': ('projects', 51), '林允': ('anecdote_tags', 208), '注射': ('first_solutions', 116152), '黄褐斑': ('second_demands', 1), '溶解酶': ('second_solutions', 1208), '除皱': ('second_demands', 10), '上颚': ('second_positions', 24), '副乳': ('second_positions', 1034), '膨体隆鼻': ('projects', 19536), '缩鼻背': ('second_demands', 132399), '手术祛腋臭': ('projects', 296), '超声波洗牙': ('projects', 31292), '激光溶脂祛眼袋': ('projects', 12), '射频溶脂塑臀': ('projects', 16), '唇毛': ('second_positions', 2155), '鼻背': ('second_positions', 64167), '脱腿毛': ('second_demands', 1375), '全脸': ('second_positions', 418503), '萧亚轩': ('anecdote_tags', 1), '异体骨': ('second_solutions', 142), '药品': ('second_solutions', 3837), '乳头': ('second_positions', 17655), '脚背': ('second_positions', 7302), '动氧': ('second_solutions', 44), '地包天': ('second_demands', 7765), '网红颜值': ('anecdote_tags', 4692), '伊婉C Plus': ('projects', 135), '处女膜修复': ('projects', 5183), '下颚前突': ('projects', 75), '苹果肌': ('second_positions', 10519), '小阴唇整形': ('projects', 982), '沙眼': ('projects', 1), '填充': ('first_solutions', 85483), '乳牙1': ('projects', 841), '上眼睑提升': ('second_demands', 82688), '颌面': ('second_positions', 19246), '生头发': ('second_demands', 28855), '氐殊': ('projects', 4), '玻尿酸丰唇珠': ('projects', 405), '下颌': ('second_positions', 15822), '腹部': ('second_positions', 25316), '脱私密毛发': ('second_demands', 8906), '胸部kyc': ('projects', 1), '像素激光': ('projects', 10924), '大臂': ('second_positions', 5827), '人工骨': ('second_solutions', 12095), '鼻部膨体假体取出': ('projects', 28), '产科手术': ('second_solutions', 21), '射频溶脂瘦大腿': ('projects', 110), '大眼睛': ('second_demands', 114031), '水氧活肤': ('projects', 3046), '水动力': ('second_solutions', 828), '溶脂针瘦小腿': ('projects', 6), '托槽矫正': ('projects', 2), '瘦下颌缘': ('second_demands', 33578), '手指': ('second_positions', 124), '刷酸': ('first_solutions', 825), '肋软骨隆鼻': ('projects', 2908), '下眼睑下至': ('second_demands', 4904), '洗眼线': ('second_demands', 233), '乳头内陷矫正': ('projects', 446), '准分子激光术': ('projects', 4), '鼻部修复': ('second_demands', 7621), '激光溶脂瘦下颌缘': ('projects', 15), '激光祛疤': ('projects', 2457), '白雪公主美白针': ('projects', 39), '赵露丝': ('anecdote_tags', 39), '明星变脸': ('anecdote_tags', 21281), '假体填充苹果肌': ('projects', 25), '手部': ('first_positions', 7570), '倪妮': ('anecdote_tags', 78), '眉毛': ('second_positions', 21022), 'PRP生发': ('projects', 7783), '天包地': ('second_demands', 25), '修复': ('first_demands', 7891), '杨紫': ('anecdote_tags', 392), '咬肌': ('second_positions', 557), '龈下刮治': ('projects', 2), '自体脂肪垫眉弓': ('projects', 93), '脸型': ('first_demands', 100592), '热玛吉': ('projects', 45978), '少女针': ('projects', 365), '切开双眼皮': ('projects', 46544), '下眼睑': ('second_positions', 2646), '胸部假体': ('second_solutions', 31284), '下巴修复': ('projects', 219), '丰眼窝': ('second_demands', 119427), '私密超声提升': ('projects', 134), '牙齿综合': ('projects', 487), '牙龈炎': ('projects', 12), '激光美肤': ('projects', 3193), '光纤溶脂瘦颈': ('projects', 1), '溶脂针瘦背': ('projects', 1), 'Angelababy': ('anecdote_tags', 557), '动氧溶脂瘦腿': ('projects', 17), '美肤': ('first_demands', 311900), '注射祛法令纹': ('projects', 378), '伊肤泉微针': ('projects', 339), '根管治疗': ('projects', 489), '正颌': ('projects', 2135), '玻尿酸祛眉间纹': ('projects', 62), '手术祛疤': ('projects', 1254), '射频溶脂瘦背': ('projects', 4), '激光脱手脚毛': ('projects', 7572), '泪沟': ('second_positions', 34402), '激光祛颈纹': ('projects', 2707), '硅胶隆胸': ('projects', 2932), 'G点': ('second_positions', 765), '祛印第安纹': ('second_demands', 1), '鼻部假体': ('second_solutions', 105335), '自体脂肪除皱': ('projects', 1), '面部护理': ('second_solutions', 34), '眉心': ('second_positions', 3591), '祛红血丝': ('second_demands', 20568), '腹部脂肪': ('second_positions', 3), '隆胸': ('second_demands', 111808), '接睫毛': ('projects', 108), '私密美化': ('second_demands', 1645), '凸嘴矫正': ('projects', 4465), '激光脱腿毛': ('projects', 2233), '异物取出': ('first_solutions', 662), '法思丽': ('projects', 22), '化学焕肤': ('projects', 2), '镶牙': ('second_solutions', 500), '脱发际线': ('second_demands', 669), '自体脂肪私密紧致': ('projects', 17791), '手术紧缩阴道': ('projects', 13764), '胸形': ('second_positions', 105264), '娱乐圈热点': ('anecdote_tags', 149), '激光洗眉': ('projects', 248), '皱纹': ('first_positions', 5441), '激光脱背毛': ('projects', 7572), '乳晕漂红': ('projects', 2173), '祛腋臭': ('second_demands', 1139), '射频溶脂瘦肩': ('projects', 13), '自体脂肪丰耳垂': ('projects', 8), 'E光祛斑': ('projects', 256), '胎盘素': ('second_solutions', 11), '光纤溶脂瘦脸': ('projects', 145), '乳腺疏通': ('projects', 791), '嘴角上扬': ('second_demands', 23019), '鼻小柱延长': ('projects', 2), '下巴截骨术': ('projects', 7623), '长脸矫正': ('projects', 51), '激光溶脂瘦手臂': ('projects', 42), '假体丰额头': ('projects', 379), '植胡须': ('projects', 100), '额发际': ('second_positions', 15044), '颌面正畸': ('projects', 732), '唇部修复': ('second_demands', 28), '电波拉皮': ('projects', 39), '恒生线': ('projects', 9), '刷酸祛斑': ('projects', 93894), '全眼': ('second_positions', 28), '下巴假体取出': ('projects', 198), '张雨绮': ('anecdote_tags', 1529), 'M唇': ('second_demands', 37007), '隆胸修复': ('projects', 27), '眼科手术': ('second_solutions', 176), '脚部': ('first_positions', 7501), '生胡须': ('second_demands', 97), '腹毛': ('second_positions', 23716), '假体祛法令纹': ('projects', 230), '动氧溶脂': ('projects', 8), '肉毒素祛颈纹': ('projects', 3), '眼窝': ('second_positions', 119809), '颜值速报': ('anecdote_tags', 6905), '冷冻溶脂瘦大腿': ('projects', 337), '腰腹': ('second_positions', 47997), '内眼角修复': ('projects', 65), '颈部提升': ('second_demands', 51), '皮秒kyc': ('projects', 2), '抗衰紧致kyc': ('projects', 2), '耳洞': ('second_demands', 103), '宽鼻矫正': ('projects', 30), '硅胶隆鼻': ('projects', 12191), '背部': ('first_positions', 9122), '自体血清': ('second_solutions', 7767), '薄唇': ('second_demands', 7722), '合金烤瓷牙': ('projects', 103), '鼻孔重塑': ('projects', 13), '美容注射': ('second_solutions', 1), '祛纹身': ('second_demands', 468), '颧骨提高': ('projects', 489), '保妥适': ('projects', 240), '注射丰乳头': ('projects', 38), '菲洛嘉1': ('projects', 2), '招风耳矫正': ('projects', 19), '爱贝芙注射': ('projects', 17), '胶原蛋白隆鼻': ('projects', 112), '鼻形': ('second_positions', 165925), '美手': ('first_demands', 69), '祛嘴角纹': ('second_demands', 49), '头发': ('second_positions', 32247), '肉毒素祛抬头纹': ('projects', 93805), '睫毛增长': ('projects', 237), '开外眼角1': ('projects', 1), '蔡卓宜': ('anecdote_tags', 5), '丰额头': ('second_demands', 16606), '玻尿酸丰额头': ('projects', 5001), '网红翻车': ('anecdote_tags', 3528), '轮廓改善': ('second_demands', 8), '睫毛': ('second_positions', 1553), '瘦手臂': ('second_demands', 4984), '全瓷牙': ('projects', 1247), '准分子激光': ('projects', 2), '内眼角': ('second_positions', 18747), '眼周': ('second_positions', 254083), '玻尿酸填充泪沟': ('projects', 33376), '假体': ('second_solutions', 9), '牙齿隐形矫正': ('projects', 77743), '产后恢复': ('second_demands', 3726), '产后塑形': ('second_demands', 165), '光纤溶脂祛副乳': ('projects', 1), '切眉': ('projects', 2594), '颌面矫正': ('second_demands', 5960), '姚晨': ('anecdote_tags', 9), '脱毛发': ('second_demands', 960), '阴茎增大': ('projects', 487), '牙齿自锁托槽矫正': ('projects', 49), '植发': ('second_solutions', 66009), '铂金美白针': ('projects', 55), '开外眼角': ('projects', 5461), '自体脂肪祛眉间纹': ('projects', 28), '斜视': ('second_demands', 26), '快翎线': ('projects', 8), '染料激光': ('second_solutions', 96), '皮肤手术': ('second_solutions', 132531), '熏蒸': ('second_solutions', 1), '吸脂瘦腹部': ('projects', 1588), '玻尿酸精华导入': ('projects', 1229), '眼综合': ('projects', 52641), '敏感肌': ('second_positions', 1), '经期调理': ('second_demands', 13), '胸部修复': ('second_demands', 9205), '牙齿美白': ('second_demands', 55500), '缩鼻头1': ('projects', 2), '缩毛孔': ('second_demands', 90326), '眼部修复': ('second_demands', 11143), '溶脂针': ('second_solutions', 267), '乳腺': ('second_positions', 705), '丰臀': ('second_demands', 6206), '面部修复': ('second_demands', 1969), '膨体垫眉弓': ('projects', 669), '小脸': ('first_demands', 765), '冷冻祛疤': ('projects', 1), '植美人尖': ('projects', 1), '迪丽热巴': ('anecdote_tags', 212), '刘亦菲': ('anecdote_tags', 422), '面部消脂': ('second_demands', 241937), '激光祛纹身': ('projects', 511), '被口罩封印的颜值': ('anecdote_tags', 10), '喷砂洗牙': ('projects', 34424), '青光眼': ('second_demands', 4), '玻尿酸丰眼窝': ('projects', 126990), '妊娠纹': ('second_positions', 1), '水光娃娃': ('projects', 5), '祛斑': ('second_demands', 103562), '阴道成形': ('second_demands', 102), '激光溶脂塑臀': ('projects', 13), '鼻中隔软骨隆鼻': ('projects', 103), '唇部': ('first_positions', 18268), '剖腹产手术': ('projects', 1), '疾病': ('first_demands', 1), '埋线祛眼袋': ('projects', 10), '手术祛法令纹': ('projects', 173), '削磨祛斑': ('projects', 156), 'HPV疫苗': ('projects', 2), '药物治疗': ('first_solutions', 109), '牙科治疗': ('first_solutions', 104257), '热立塑': ('projects', 60), '颧骨颧弓降低': ('projects', 15957), '药物脱毛': ('projects', 4412), '美白针kyc': ('projects', 2), '漂红': ('second_solutions', 6079), '水杨酸焕肤': ('projects', 117), '塑料姐妹花': ('anecdote_tags', 222), '玻尿酸丰太阳穴': ('projects', 12507), '正骨术': ('projects', 67), '导入': ('second_solutions', 20859), '娱乐八卦': ('anecdote_tags', 6928), '王祖贤': ('anecdote_tags', 3), '综合面部整形': ('projects', 18188), '缩短下巴': ('second_demands', 166324), '新生代网红': ('anecdote_tags', 1608), '吸脂瘦手臂': ('projects', 4670), '点阵激光': ('projects', 9101), '射频溶脂祛眼袋': ('projects', 11), '鼻孔矫正': ('second_demands', 1849), '上眼睑': ('second_positions', 93006), '缩鼻孔': ('projects', 20), '吸脂': ('second_solutions', 116439), '耳软骨隆鼻': ('projects', 3598), '软骨矫正': ('second_solutions', 68422), '祛晒斑': ('second_demands', 168), '护肤品': ('first_solutions', 402), '祛痣': ('second_demands', 52534), '断骨增高': ('projects', 30), '胶原蛋白祛法令纹': ('projects', 173), '聚左旋乳酸': ('second_solutions', 1), '玻尿酸丰面颊': ('projects', 3046), '明星颜值': ('anecdote_tags', 36230), '肤质检测': ('projects', 432), '嗨体祛颈纹': ('projects', 14), '变性手术1': ('projects', 1), '牙齿冷光美白': ('second_solutions', 508), '水光针kyc': ('projects', 2), '乔雅登': ('projects', 44), '瘦腰部': ('second_demands', 3249), '胶原蛋白填充卧蚕': ('projects', 3), '综合祛疤': ('projects', 5043), '颊脂垫': ('second_positions', 3262), '射频祛眼袋': ('projects', 1420), '脱毛': ('first_demands', 45263), '激光脱胡子': ('projects', 12), '奥美定': ('second_demands', 120), '面部紧致提升': ('projects', 6005), '唇珠唇弓': ('projects', 17613), '假体垫眉弓': ('projects', 946), '伊婉C': ('projects', 135), '骨盆': ('second_positions', 91), '激光美白': ('projects', 90), '抗衰紧致': ('projects', 4882), '埋线隆鼻': ('projects', 1810), '填充泪沟': ('second_demands', 33211), '上眼睑祛脂': ('projects', 36), '鼻部硅胶假体取出': ('projects', 53), '瘦腰腹': ('second_demands', 24622), '耳朵': ('second_positions', 922), '缩胸': ('second_demands', 408), '植睫毛': ('projects', 416), '人中延长': ('second_demands', 42), '青春解码仪美肤': ('projects', 3), '肉毒素缩鼻头': ('projects', 52), '乳头漂红': ('projects', 60), '私人定制': ('projects', 70), '瘦背': ('second_demands', 1872), '垫鼻头': ('second_demands', 245), '缩下巴': ('projects', 171773), '射频祛黑眼圈': ('projects', 1005), '头顶加密种植': ('projects', 188), '颧骨': ('second_positions', 18186), '胸毛': ('second_positions', 11), '避孕': ('second_demands', 61), '牙齿恒温美白': ('second_solutions', 22544), '产科': ('first_demands', 5097), '阴唇美化': ('second_demands', 14699), '自体脂肪修复': ('second_demands', 17410), '颌面修复': ('projects', 198), '人工流产': ('projects', 15), '溶脂针瘦下颌缘': ('projects', 7), '垫鼻基底': ('second_demands', 13559), '女变男': ('second_demands', 49), '膨体丰太阳穴': ('projects', 107), '外切祛眼袋': ('projects', 3391), '胸部': ('first_positions', 153092), '自体脂肪祛黑眼圈': ('projects', 1646), '彩光嫩肤': ('projects', 100), '定点双眼皮': ('projects', 63724), '植毛': ('second_solutions', 1563), '冷冻祛腋臭': ('projects', 1), '祛雀斑': ('second_demands', 465), '漂唇': ('projects', 1679), '无针水光': ('projects', 8068), '自体脂肪丰面颊': ('projects', 9192), '瘦肩': ('second_demands', 18517), '烤瓷牙': ('projects', 748), '面部皮肤': ('second_positions', 60121), 'PRP美肤': ('projects', 813), '90后小白花扒皮': ('anecdote_tags', 3884), '牙齿疾病治疗': ('second_solutions', 1731), '脖子': ('second_positions', 18031), '祛肿眼泡': ('second_demands', 2857), '斑': ('second_positions', 1), '牙病': ('second_demands', 5252), '鼻部': ('first_demands', 240637), '阿娇': ('anecdote_tags', 58), '瘦腿针': ('projects', 35921), '男性私处': ('first_positions', 1214), '郭碧婷': ('anecdote_tags', 1), '颧骨内推': ('second_demands', 27578), '私密清洁': ('projects', 32), '植私密毛发': ('projects', 17799), '吸脂祛双下巴': ('projects', 16754), '药浴': ('second_solutions', 2), '足疗': ('projects', 6), '人工骨垫下巴': ('projects', 204), '手掌': ('second_positions', 6762), '丰太阳穴': ('second_demands', 18877), '自体脂肪丰眼窝': ('projects', 139), '脚部整形': ('second_demands', 31), '缩下颌角': ('second_demands', 24327), '综合隆胸': ('projects', 71), '乳腺护理': ('second_demands', 666), '修复手术': ('second_solutions', 88978), '蔡徐坤': ('anecdote_tags', 122), '中医瘦身': ('projects', 658), '耳再造': ('projects', 6), '光纤溶脂瘦下颌缘': ('projects', 14), '颧骨修复': ('projects', 890), '阴蒂美化': ('second_demands', 2378), '激光祛胎记': ('projects', 1), '瘦全身': ('second_demands', 105907), '针清': ('projects', 651), '痘': ('second_positions', 1), '牙周护理': ('projects', 758), '淋巴': ('second_positions', 30), '眼部护理': ('second_demands', 1120), '皮肤病': ('second_demands', 267), '射频提升': ('projects', 11654), '玻尿酸祛法令纹': ('projects', 5293), '颧骨提升': ('second_demands', 495), '阴蒂': ('second_positions', 1854), '胶原蛋白丰额头': ('projects', 1), '隔空溶脂': ('projects', 201), '半永久睫毛线': ('projects', 21), '提眉修复': ('projects', 1245), '眼科检查': ('second_solutions', 155), '水光仪': ('second_solutions', 15), '隔空溶脂祛副乳': ('projects', 1), '恒温美白': ('projects', 4), '面部不对称改善': ('projects', 784), '激光溶脂瘦腿': ('projects', 954), '鼻小柱美化': ('second_demands', 2), '鼻小柱': ('second_positions', 3421), '瑞蓝2号': ('projects', 46), '唇型': ('second_positions', 2), '胶原蛋白垫下巴': ('projects', 58), '果酸焕肤': ('projects', 20214), '填充面部': ('second_demands', 100202), '软骨隆鼻': ('projects', 32920), '吸脂瘦颈部': ('projects', 374), '刘恺威': ('anecdote_tags', 10), '手术近视矫正': ('projects', 4), '胶原蛋白丰臀': ('projects', 2), '半永久纹眼线': ('projects', 8071), '超声刀': ('second_solutions', 347), '唇部美化kyc': ('projects', 1), '冷冻': ('second_solutions', 126), '牙齿托槽矫正': ('projects', 23633), '富二代大瓜': ('anecdote_tags', 550), '激光溶脂祛副乳': ('projects', 1), '激光溶脂瘦颈': ('projects', 1), '开眼角修复': ('projects', 1862), '冷冻溶脂瘦手臂': ('projects', 23), '注射祛疤': ('projects', 1304), '自体脂肪丰臀': ('projects', 3368), '厚唇改薄1': ('projects', 7), '超声溶脂瘦腹部': ('projects', 45), '吸脂瘦脸': ('projects', 241206), '张予曦': ('anecdote_tags', 35), '臀形': ('second_positions', 57), '膝盖': ('second_positions', 157), '自体脂肪垫下巴': ('projects', 2303), '胶原蛋白丰唇': ('projects', 548), '自体脂肪填充苹果肌': ('projects', 6043), '激光美肤kyc': ('projects', 1), '毛孔': ('second_positions', 1), '吸脂瘦大腿': ('projects', 8612), '综合治疗': ('second_solutions', 191025), '眼科激光矫正': ('second_solutions', 672), '焕肤美白': ('projects', 93888), '肩颈护理': ('projects', 2), '自体脂肪存储': ('projects', 3), '窝沟封闭': ('projects', 126), '洁面': ('second_demands', 41781), '红蓝光': ('second_solutions', 11200), '乳晕美化': ('second_demands', 2827), '口腔综合治疗': ('projects', 1049), '赵薇': ('anecdote_tags', 1), '填充卧蚕': ('second_demands', 2514), '缩眼距': ('second_demands', 58893), '散光矫正': ('projects', 1), '激光脱唇毛': ('projects', 2713), '张艺兴': ('anecdote_tags', 626), '开内眼角': ('projects', 18516), '丰耳垂': ('second_demands', 71), '胸部护理': ('projects', 3), '牙周病': ('projects', 136), '玻尿酸隆胸': ('projects', 30050), '网红撕X': ('anecdote_tags', 1512), '皮秒': ('second_solutions', 55065), '伊婉V Plus': ('projects', 135), '自体脂肪隆鼻': ('projects', 14287), '激光溶脂': ('projects', 5726), '点穴': ('second_solutions', 8), '自体脂肪祛皱': ('projects', 40039)}
    user_portrait_dict = user_portrait_scan_info()
    print(user_portrait_dict)
    # 获取全部标签
    all_tags = get_channel_tags_info()
    print(all_tags)
    # 获取标签对应的日记帖子回答数
    # article_num_dict = get_es_article_num(all_tags)
    # 获取曝光的id
    card_id_dict = get_card_id()
    print(card_id_dict)
    # 获取曝光id对应的标签
    word_count_exposure = from_id_get_tag(card_id_dict)
    print(word_count_exposure)
    save_data_to_csv(user_portrait_dict, word_count_exposure)


if __name__ == "__main__":
    parse_data()
