package com.gengmei.meigou

import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment
import org.apache.flink.streaming.api.scala._
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment
import org.apache.flink.api.scala._
import org.apache.flink.table.api.{DataTypes, EnvironmentSettings}
import org.apache.flink.table.descriptors.{Csv, Kafka, Schema}

object ServiceTransfer {
  def main(args: Array[String]): Unit = {

    val bsEnv = StreamExecutionEnvironment.getExecutionEnvironment
    val bsSettings = EnvironmentSettings.newInstance().useBlinkPlanner().inStreamingMode().build()
    val bsTableEnv = StreamTableEnvironment.create(bsEnv, bsSettings)
    val tableSql = """
                     |CREATE TABLE AreaTable (
                     |  id INT,
                     |  area_name STRING,
                     |  phone_prefix STRING
                     |) WITH (
                     |  'connector' = 'jdbc',
                     |  'url' = 'jdbc:mysql://47.94.7.135:3306/test',
                     |  'table-name' = 'table1',
                     |  'username' = 'test',
                     |  'password' = 'Test@1234'
                     |)
""".stripMargin
    bsTableEnv.executeSql(tableSql)

        val tableSql1 = """
                          |CREATE TABLE AreaTable1 (
                          |  id INT,
                          |  area_name STRING,
                          |  phone_prefix STRING
                          |) WITH (
                          |  'connector' = 'jdbc',
                          |  'url' = 'jdbc:mysql://47.94.7.135:3306/test',
                          |  'table-name' = 'table2',
                          |  'username' = 'test',
                          |  'password' = 'Test@1234'
                          |)
    """.stripMargin
//    bsTableEnv.executeSql(tableSql1)


    val KafkaTable =      """
                            |CREATE TABLE kafkaTable (
                            |   id INT,
                            |  area_name STRING,
                            |  phone_prefix STRING
                            |) WITH (
                            |'connector' = 'kafka',
                            |'topic' = 'topic_2', -- required: topic name from which the table is read
                            |'properties.bootstrap.servers' = '47.94.7.135:9092', -- required: specify the Kafka server connection string
                            |'format' = 'csv'
                            |)
                            |""".stripMargin

    bsTableEnv.executeSql(KafkaTable)
    bsTableEnv.executeSql("INSERT INTO kafkaTable SELECT id,area_name,phone_prefix from AreaTable")
//    bsTableEnv.executeSql("INSERT INTO AreaTable1 SELECT id,area_name,phone_prefix from AreaTable")

  }
}
