import requests
import unittest

from param import params
from login import case_login
from case import getMethod


class Case(unittest.TestCase):
    # 全局变量
    s = requests.session()
    uri = params.uri
    test_uri = "http://earth.gmapp.env"
    master_uri = "http://earth.iyanzhi.com"

    # 类内变量
    pictorial_info = params.pictorial_info
    pictorial_list = params.pictorial_list
    default_content = params.default_content
    pictorial_card = params.pictorial_card
    info = params.info
    pictorial_and_topic = params.pictorial_and_topic
    pictorial_search = params.pictorial_search
    @classmethod
    def setUpClass(cls):
        # 调用登陆类 传入会话保持，进行赋值
        cls.login = case_login.login(cls.s)
        # 带有会话保持的类调用期方法。传入uri  相当于已经赋予了值
        cls.login.LoginMethod(cls.uri)

    # 通用接口
    def test_01(self):
        'earth榜单活动信息接口'
        p = "earth榜单活动信息接口"
        url = self.uri + self.pictorial_info
        result = self.s.get(url=url)
        getMethod.getmethod(p,result)

    def test_02(self):
        'earth榜单活动卡片接口'
        p = "earth榜单活动卡片接口"
        url = self.uri +self.pictorial_list
        result = self.s.get(url=url)
        getMethod.getmethod(p,result)


    def test_03(self):
        '榜单默认内容（换一换）接口'
        p = "榜单默认内容（换一换）接口"
        url = self.uri + self.default_content
        result = self.s.get(url=url)
        getMethod.getmethod(p,result)

    def test_03(self):
        '画报信息接口'
        p = "画报信息接口"
        if self.uri == self.test_uri:
            pictorial_id = "286487"
        if self.uri == self.master_uri:
            pictorial_id = "316139"
        url = self.uri + self.info+ "?pictorial_id=" + pictorial_id
        result = self.s.get(url=url)
        getMethod.getmethod(p,result)

    def test_04(self):
        '画报卡片'
        p = "画报卡片接口01"
        url = self.uri +self.pictorial_card +"use_type=1"
        result = self.s.get(url=url)
        getMethod.getmethod(p,result)

    def test_05(self):
        '画报卡片'
        p = "画报卡片接口02"
        url = self.uri +self.pictorial_card +"use_type=2"
        result = self.s.get(url=url)
        getMethod.getmethod(p,result)

    def test_06(self):
        '画报帖子添加关系接口'
        p = "画报帖子添加关系接口"
        if self.uri == self.test_uri:
            body = {
                "pictorial_id" : 286487,
                "topic_id" : 46745387
           }
        if self.uri == self.master_uri:
            body = {
                       "pictorial_id":316535,
                   "topic_id":46831243
            }
        url = self.uri +self.pictorial_and_topic
        result = self.s.post(url=url , data=body)
        getMethod.getmethod(p,result)


    def test_07(self):
        '画报搜索'
        p = "画报搜索"
        if self.uri == self.test_uri:
            name = "name=aaa"
        if self.uri == self.master_uri:
            name = "明星"
        url = self.uri + self.pictorial_search + "?name=" + name
        result = self.s.get(url=url)
        getMethod.getmethod(p,result)



