import requests
import unittest

from param import params
from login import case_login
from assert_method import assertclass
class Case(unittest.TestCase):

    # 全局变量
    s = requests.session()
    uri = params.uri
    Attention = params.Attention
    test_id = params.test_id
    test_type = params.test_type
    master_id = params.master_id
    master_type = params.master_type
    AttentionList = params.AttentionList
    test_uri = "http://earth.gmapp.env"
    master_uri = "http://earth.iyanzhi.com"
    cancel_follow = params.cancel_follow

    @classmethod
    def setUpClass(cls):
        # 调用登陆类 传入会话保持，进行赋值
        cls.login = case_login.login(cls.s)
        # 带有会话保持的类调用期方法。传入uri  相当于已经赋予了值
        cls.login.LoginMethod(cls.uri)


    def test_01(self):
        '关注接口'
        p = "关注接口"
        url = self.uri + self.Attention
        if self.uri == self.test_uri:

            body = {
                "id": self.test_id,
                "type": self.test_type
            }
        if self.uri == self.master_uri:
            body = {
                "id": self.master_id,
                "type": self.master_type
            }
        result = self.s.post(url, data=body)
        code = result.status_code
        if code == 200:
            res = result.json()
            print(p + str(res))
            error_code = res.get("error")
            assertclass.error_code(error_code,p)
            assertclass.runtime(result,p)
        else:
            assertclass.statuecode(code,p)


    def test_02(self):
        '关注接口列表'
        p = "关注接口列表"
        url = self.uri + self.AttentionList
        result = self.s.get(url=url)
        code = result.status_code
        if code == 200:
            res = result.json()
            print(p + str(res))
            error_code = res.get("error")
            assertclass.error_code(error_code,p)
            if self.uri == self.test_uri:
                pass
            if self.uri == self.master_uri:
                pass
            assertclass.runtime(result,p)
        else:
            assertclass.statuecode(code,p)



    def test_03(self):
        '取消关注'
        p = "取消关注接口"
        url = self.uri + self.cancel_follow
        if self.uri == self.test_uri:

            body = {
                "id": self.test_id,
                "type": self.test_type
            }
        if self.uri == self.master_uri:
            body = {
                "id": self.master_id,
                "type": self.master_type
            }
        result = self.s.post(url=url,data=body)
        code = result.status_code
        if code == 200:
            res = result.json()
            print(p + str(res))
            error_code = res.get("error")
            assertclass.error_code(error_code,p)
            assertclass.runtime(result,p)