import requests
import unittest

from param import params
from login import case_login
from assert_method import assertclass
from case import getMethod
class Case(unittest.TestCase):

    # 全局变量
    s = requests.session()
    uri = params.uri
    test_uri = "http://earth.gmapp.env"
    master_uri = "http://earth.iyanzhi.com"

    #类内变量
    my_news = params.my_news
    unread = params.unread
    likelist = params.likelist
    socketaddress = params.socketaddress
    new_info = params.new_info
    notice = params.notice
    upload_token = params.upload_token

    @classmethod
    def setUpClass(cls):
        # 调用登陆类 传入会话保持，进行赋值
        cls.login = case_login.login(cls.s)
        # 带有会话保持的类调用期方法。传入uri  相当于已经赋予了值
        cls.login.LoginMethod(cls.uri)

    # 通用接口
    def test_01(self):
        '我的消息接口'
        p = "我的消息接口"
        url = self.uri + self.my_news
        result = self.s.get(url=url)
        getMethod.getmethod(p,result)

    # 通用接口
    def test_02(self):
        '点赞关注未读数'
        p = "点赞关注未读数"
        url = self.uri + self.unread
        result = self.s.get(url=url)
        getMethod.getmethod(p,result)

    # 通用接口
    def test_03(self):
        '点赞列表接口'
        p = "点赞列表接口"
        url = self.uri + self.likelist
        result = self.s.get(url=url)
        getMethod.getmethod(p,result)

    #通用接口
    def test_04(self):
        '获取socket地址'
        p = "获取socket地址"
        url = self.uri + self.socketaddress
        result = self.s.get(url=url)
        getMethod.getmethod(p,result)

    # 通用接口
    def test_05(self):
        '取最新通知信息'
        p = "取最新通知信息"
        url = self.uri + self.new_info
        result = self.s.get(url=url)
        getMethod.getmethod(p, result)


    # 通用接口
    def test_06(self):
        '通知列表'
        p = "通知列表"
        url = self.uri + self.notice
        result = self.s.get(url=url)
        getMethod.getmethod(p, result)


    def test_07(self):
        '上传文件token获取'
        p = "上传文件token获取"
        url = self.uri + self.upload_token
        body = {
            "token_type":1
        }
        result = self.s.post(url=url,data=body)
        getMethod.getmethod(p,result)

    