import requests
import unittest
from interface import interface
from ddt import ddt,data
import os
from pprint import pprint
import yaml
from requests.cookies import cookiejar_from_dict
import jsonpath
import json

#获取上级目录路径
path = os.path.abspath(os.path.dirname(os.path.dirname(__file__)))
# 拼接需要的目录
path = os.path.join(path,"test_yaml","customer_pool.yaml")

# 打开文件夹 读取数据
file1 = open(path,'r', encoding="utf-8")
file2 = file1.read()
file3 = yaml.load(file2)

# print("所有数据列表陈列：开始")
# pprint(file3)
# print("所有数据列表陈列：结束"+ '\n')
#

@ddt
class Case(unittest.TestCase):
    @data(*file3)
    def test_01_customer_pool(self,contents):
        '客服客户池列表页接口'
        # print("预期响应数据：开始")
        # pprint(contents)
        # print("预期响应数据：结束")
        URL = interface.hera_host+interface.customer_pool_interface
        body = contents.get("request").get("body")
        body = str(body).replace('True',"'true'").replace('False',"'false'").replace('None',"''")
        print(body)
        cookies = interface.hera_cookies
        result = requests.post(url=URL, cookies=cookiejar_from_dict(cookies), data=eval(body),verify=False)
        res = result.json()
        print("实际返回数据：开始")
        pprint(res)
        print("实际返回数据：结束")
        response = contents.get("request").get("response")

        for k, v in response.items():
            # k是配置参数里面的路径  通过k设定 去res里面找到实际的数据。 由于jsonpath返回的是一个列表 所以要用【0】处理。返回回去的就是一个取出来的数值  eg："data.0.doctor_id"
            res_response = jsonpath.jsonpath(res, k)[0]
            v = eval(v)
            # assertmethod = self.assertEqual/self.assertIsInstance 取决于上面参数内写的是什么方法。   作用： getattr(object, name)  =  object.name
            for i in range(len(v)):
                assertmethod = getattr(self, v[i][0])
                assertmethod(res_response, v[i][1])

