import requests
import sys,os

sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

import unittest
from interface import interface
from requests.cookies import cookiejar_from_dict
from pprint import pprint
from ddt import ddt,data
import jsonpath
import yaml

#获取上级目录路径
path = os.path.abspath(os.path.dirname(os.path.dirname(__file__)))
# 拼接需要的目录
path = os.path.join(path,"test_yaml","om_distribution.yaml")

# 打开文件夹 读取数据
file1 = open(path,'r', encoding="utf-8")
file2 = file1.read()
file3 = yaml.load(file2)

print("所有数据列表陈列：开始")
pprint(file3)
print("所有数据列表陈列：结束"+ '\n')

@ddt
class case(unittest.TestCase):
    @data(*file3)
    def test_01_distribution_list(self,contents):
        'om后台客服客户池已分配客户列表接口'
        URL = interface.om_host  + interface.om_distribution_list
        body = contents.get("request").get("body")
        cookies = interface.om_cookies
        result = requests.get(url=URL,cookies=cookies,params=body,verify=False)
        res = result.json()
        print("真实数据返回开始")
        pprint(res)
        print("真实数据返回结束")
        response = contents.get("request").get("response")

        for k, v in response.items():
            # k是配置参数里面的路径  通过k设定 去res里面找到实际的数据。 由于jsonpath返回的是一个列表 所以要用【0】处理。返回回去的就是一个取出来的数值  eg："data.0.doctor_id"
            res_response = jsonpath.jsonpath(res, k)[0]
            v = eval(v)
            # assertmethod = self.assertEqual/self.assertIsInstance 取决于上面参数内写的是什么方法。   作用： getattr(object, name)  =  object.name
            for i in range(len(v)):
                assertmethod = getattr(self, v[i][0])
                assertmethod(res_response, v[i][1])



