import sys
import json

from django.conf import settings
from pymysqlreplication import BinLogStreamReader
from pymysqlreplication.row_event import DeleteRowsEvent, WriteRowsEvent, UpdateRowsEvent
from engine.redis_base import _PoolMinx
from engine.lazy_data_sync import LazyDataHandle
from settings.mapping import table_index

MYSQL_SETTINGS = {'host': '127.0.0.1', 'port': 3306, 'user': 'root', 'passwd': '12345678'}

last_record_time = _PoolMinx.get_last_record()


def listen_data():
    stream = BinLogStreamReader(
        connection_settings=settings.MYSQL_SETTINGS,
        server_id=3,
        blocking=True,
        only_schemas=['demo'],
        only_tables=["runoob_tbl"],
        only_events=[DeleteRowsEvent, WriteRowsEvent, UpdateRowsEvent],
        skip_to_timestamp=last_record_time)

    for binlogevent in stream:
        for row in binlogevent.rows:
            event = {"schema": binlogevent.schema, "table": binlogevent.table, 'time': binlogevent.timestamp}
            if isinstance(binlogevent, DeleteRowsEvent):
                event["action"] = "delete"
                event["values"] = dict(row["values"].items())
                event = dict(event.items())
            elif isinstance(binlogevent, UpdateRowsEvent):
                event["action"] = "update"
                event["before_values"] = dict(row["before_values"].items())
                event["after_values"] = dict(row["after_values"].items())
                event = dict(event.items())
            elif isinstance(binlogevent, WriteRowsEvent):
                event["action"] = "insert"
                event["values"] = dict(row["values"].items())
                event = dict(event.items())

            if int(event.get("time") or 0) <= last_record_time:
                #比较最后一条记录时间过滤
                continue
            #Todo同步到数据库
            print(json.dumps(event))
            table_index[event.get("table")].handle_data(event)
            # LazyDataHandle.handle_data()
            sys.stdout.flush()

    stream.close()