from engine.lazy_data_sync import LazyDataHandle
from engine.redis_base import LazyRecord


class LocalDemo(LazyDataHandle):

    @classmethod
    def insert_data(cls, data):
        table_name = data.get("table")
        if not table_name:
            return

        values = data.get('values')
        in_value = [{
            "create": {
                "_index": table_name,
                "_type": table_name,
                "_id": values.get("runoob_id")
            }}, {
            "title": values.get("runoob_title", "") or ""
         }]
        redis_cli = LazyRecord(model_name=table_name)
        redis_cli.handle(data=in_value, index=table_name, doc_type=table_name)

    @classmethod
    def update_data(cls, data):
        table_name = data.get("table")
        if not table_name:
            return

        values = data.get('after_values')

        update_value = [{
            "update": {
                "_id": values.get("runoob_id"),
                "_index": table_name,
                "_type": table_name,
            }
        }, {
            "doc": {
                "title": values.get("runoob_title") or ""
            }
        }]
        redis_cli = LazyRecord(model_name=table_name)
        redis_cli.handle(data=update_value, index=table_name, doc_type=table_name)

    @classmethod
    def del_data(cls, data):

        table_name = data.get("table")
        if not table_name:
            return

        values = data.get('values')
        out_value = [{
            "delete": {
                "_index": table_name,
                "_id": values.get("runoob_id"),
                "_type": table_name,
            }
        }]
        redis_cli = LazyRecord(model_name=table_name)
        redis_cli.handle(data=out_value, index=table_name, doc_type=table_name)