# -*- coding: utf-8 -*-

import redis
import json
from django.conf import settings
from engine.es_base import ESPerform


class _PoolMinx(object):
    pool = redis.ConnectionPool(**settings.REDIS['es_lazydata'])
    client = redis.Redis(connection_pool=pool)

    def get_lazykey(self):
        keys_list = self.client.keys("lazydata__*")
        return [item.decode('utf-8') for item in keys_list]

    def del_key_data(self, key):
        self.client.delete(key)
        return

    @classmethod
    def update_last_record(cls, time_number):
        cls.client.set("last_update_time", time_number)

    @classmethod
    def get_last_record(cls):
        last_time = cls.client.get("last_update_time")
        return int(last_time or 0)


class LazyRecord(_PoolMinx):
    def __init__(self, model_name):
        self.prefix = "lazydata__"
        self._index = model_name
        self.model_name = self.prefix + model_name

    def handle(self, data, index="", doc_type=""):
        """插入一条数据"""
        if not data:
            return

        value_list = []
        for item in data:
            value_list.append(item)

        value_list = tuple(value_list)
        self.client.rpush(self.model_name, *value_list)

        data_lenth = self.get_len()
        if data_lenth >= 1:
            in_data = self.pop_data()
            ESPerform.lazy_batch(in_data, index, doc_type)

        return

    def get_data(self):
        result = self.client.lrange(name=self.model_name, start=0, end=-1)  # 拿到全部数据
        return result

    def get_len(self):
        result_len = self.client.llen(name=self.model_name)
        return result_len

    def clear_data(self):
        """清空数据"""
        self.client.delete(self.model_name)
        return

    def pop_data(self, pop_count=1):
        """pop数据"""
        result = self.client.lrange(name=self.model_name, start=0, end=pop_count)
        for item in result:
            self.client.lpop(name=self.model_name)

        return result

    def push_data(self, data):
        """EXCEPTION TO DO"""
        for item in data:
            self.client.lpush(self.model_name, item)
