import sys
import json

from django.conf import settings
from pymysqlreplication import BinLogStreamReader
from pymysqlreplication.row_event import DeleteRowsEvent, WriteRowsEvent, UpdateRowsEvent

MYSQL_SETTINGS = {'host': '127.0.0.1', 'port': 3306, 'user': 'root', 'passwd': '12345678'}

kafka_setting = {}


def listen_data():
    stream = BinLogStreamReader(
        connection_settings=settings.MYSQL_SETTINGS,
        server_id=3,
        blocking=True,
        only_schemas=['demo'],
        only_tables=["runoob_tbl"],
        only_events=[DeleteRowsEvent, WriteRowsEvent, UpdateRowsEvent])
    # producer = KafkaProducer(kafka_setting, topic_setting)

    for binlogevent in stream:
        for row in binlogevent.rows:
            event = {"schema": binlogevent.schema, "table": binlogevent.table}
            if isinstance(binlogevent, DeleteRowsEvent):
                event["action"] = "delete"
                event["values"] = dict(row["values"].items())
                event = dict(event.items())
            elif isinstance(binlogevent, UpdateRowsEvent):
                event["action"] = "update"
                event["before_values"] = dict(row["before_values"].items())
                event["after_values"] = dict(row["after_values"].items())
                event = dict(event.items())
            elif isinstance(binlogevent, WriteRowsEvent):
                event["action"] = "insert"
                event["values"] = dict(row["values"].items())
                event = dict(event.items())
            print(json.dumps(event))

            sys.stdout.flush()

    stream.close()