from elasticsearch import Elasticsearch, helpers
from django.conf import settings


class ESPerform(object):
    cli_obj = None
    cli_info_list = settings.ES_HOSTS

    @classmethod
    def get_cli(cls, cli_info=None):
        try:
            init_args = {
                'sniff_on_start': False,
                'sniff_on_connection_fail': False,
            }
            es_cli_info = cli_info if cli_info else cls.cli_info_list
            cls.cli_obj = Elasticsearch(hosts=es_cli_info, **init_args)
            return cls.cli_obj
        except:
            return None

    @classmethod
    def create_data(cls, index="", body={}):
        cls.cli_obj.create(index=index, body=body)

    @classmethod
    def del_data(cls, index="", sql_id=""):
        if not sql_id:
            return

        query = {'query': {'term': {'sql_id': sql_id}}}
        result = cls.cli_obj.search(index=index, body=query)
        if result.get('hits') and result['hits'].get('hits') and result['hits']['hits'][0]:
            result = result['hits']['hits'][0]
            cls.cli_obj.delete(index=index, id=result.get("_id"))

    @classmethod
    def update_data(cls, index="", sql_id="", body={}):
        if not sql_id:
            return

        query = {'query': {'term': {'sql_id': sql_id}}}
        result = cls.cli_obj.search(index=index, body=query)
        if result.get('hits') and result['hits'].get('hits') and result['hits']['hits'][0]:
            result = result['hits']['hits'][0]
            if not result.get("_id"):
                return
            cls.cli_obj.update(index="my_index", id=result.get("_id"), body={"doc": body})

    @classmethod
    def lazy_create(cls, body):
        helpers.bulk(cls.cli_obj, body)