# -*- coding: utf-8 -*-

import redis
import json
from django.conf import settings


class _PoolMinx(object):
    pool = redis.ConnectionPool(**settings.REDIS['es_lazydata'])
    client = redis.Redis(connection_pool=pool)

    def get_lazykey(self):
        keys_list = self.client.keys("lazydata__*")
        return [item.decode('utf-8') for item in keys_list]

    def del_key_data(self, key):
        self.client.delete(key)
        return


class LazyRecord(_PoolMinx):
    def __init__(self, model_name):
        self.prefix = "lazydata__"
        self._index = model_name
        self.model_name = self.prefix + model_name

    def insert(self, data):
        """插入一条数据"""
        if not data:
            return

        data = json.dumps(data)
        self.client.rpush(self.model_name, json.dumps(data))
        return

    def get_data(self):
        result = self.client.lrange(name=self.model_name, start=0, end=-1)  # 拿到全部数据
        return result

    def get_len(self):
        result_len = self.client.llen(name=self.model_name)
        return result_len

    def clear_data(self):
        """清空数据"""
        self.client.delete(self.model_name)
        return

    def pop_data(self, pop_count=1):
        """pop数据"""
        result = self.client.lrange(name=self.model_name, start=0, end=pop_count)
        for item in result:
            self.client.lpop(name=self.model_name)

        return result

    def push_data(self, data):
        """EXCEPTION TO DO"""
        for item in data:
            self.client.lpush(self.model_name, item)