# -*- coding: utf-8 -*-

import functools

from django.conf import settings
from django.core.wsgi import WSGIHandler
from django.db import signals

from gm_rpcd import all
from helios.rpc import create_default_invoker

_all__ = ['rpc_invoker', 'bind', 'Bind']


rpc_invoker = create_default_invoker(
    debug=settings.DEBUG
).with_config(
    dump_curl=settings.DEBUG
)


def bind(endpoint, **options):

    endpoint = 'psdon/' + endpoint
    return all.bind(endpoint, **options)


class Context(object):

    @property
    def rpc(self):
        return all.context.rpc


class Bind(object):
    project = 'venus'
    app = ''
    exception_map = {}

    def _bind(self, endpoint, with_context=False):
        def _wrap(func):
            @functools.wraps(func)
            def _wrapper(*args, **kwargs):
                self.request_start(*args, **kwargs)
                try:
                    if with_context:
                        data = func(Context(), *args, **kwargs)
                    else:
                        data = func(*args, **kwargs)
                except Exception as e:
                    raise self.exception_map.get(type(e), e)
                finally:
                    self.request_end(*args, **kwargs)

                return self.format_data(data)

            return all.bind('{}/{}/{}'.format(self.project, self.app, endpoint))(_wrapper)

        return _wrap

    def request_start(self, *args, **kwargs):
        signals.request_started.send(sender=WSGIHandler)

    def request_end(self, *args, **kwargs):
        signals.request_finished.send(sender=WSGIHandler)

    def format_data(self, data):
        return data

    def bind_context(self, endpoint):
        return self._bind(endpoint, with_context=True)

    def __call__(self, endpoint, with_context=False):
        return self._bind(endpoint, with_context)
