import requests
import json

from celery import shared_task
from django.conf import settings
from engine.redis_base import LazyRecord, _PoolMinx
from engine.es_base import ESPerform


@shared_task
def data_sync():
    redis_pool = _PoolMinx()
    key_list = redis_pool.get_lazykey()

    for lazy_key in key_list:
        lazy_cli = LazyRecord(model_name=lazy_key)
        lazy_data = lazy_cli.pop_data(pop_count=settings.LazyLen)
        try:
            ESPerform.lazy_create(lazy_data)
        except:
            lazy_cli.push_data(lazy_data)
