import json
from elasticsearch import Elasticsearch, helpers
from django.conf import settings
from engine.track_error import track_handle
ES_HOSTS = ['127.0.0.1:9200']


class ESPerform(object):
    cli_obj = Elasticsearch('127.0.0.1:9200')
    cli_info_list = ES_HOSTS    #settings.ES_HOSTS

    @classmethod
    def get_cli(cls, cli_info=None):
        try:
            init_args = {
                'sniff_on_start': False,
                'sniff_on_connection_fail': False,
            }
            es_cli_info = cli_info if cli_info else cls.cli_info_list
            cls.cli_obj = Elasticsearch('127.0.0.1:9200')
            return cls.cli_obj
        except:
            return None

    @classmethod
    def lazy_batch(cls, body, index, doc_type):
        """批量处理 包括增删改"""

        data = []
        for item in body:
            item = json.loads(item.decode("utf-8").replace("\'", "\""))
            data.append(item)

        cls.cli_obj.bulk(index=index, doc_type=doc_type, body=data)