# 小赢backend接口文档


## 接口列表

- 银行列表 `pay/installment/banks`
- 省市列表 `pay/installment/cities`
- 计算分期金额 `pay/installment/calc`
- 注册并实名认证 `pay/installment/register`
- 用户信息填写 `pay/installment/userinfo`
- 绑定代扣银行卡预校验 `pay/installment/check_bank`
- 绑定银行卡 `pay/installment/bind_bank`
- 申请借款 `pay/installment/loan`
- 查询借款状态 `pay/installment/status`
- 补充审核资料 `pay/installment/replenish`
- 退款或放弃贷款 `pay/installment/refund`
- 用户借款信息 `pay/installment/user`


### 1. 银行列表


#### 请求方式
    
    pay/installment/banks

#### 请求参数
``` javascript
{
    partner: 'xiaoying',
}
```

#### 返回值
```javascript
{
    
    ICBC: {
        id: 1,
        code: "ICBC",
        name: "中国工商银行",
        phone: "95588",
        icon: "http://....",
        description: "单笔限额5万, 日限额10万",
        created_time: "2016-07-01 11:34:09"
    },
    ...
}
```


### 2. 省市列表


#### 请求方式
    
    pay/installment/cities

#### 请求参数
``` javascript
{
    partner: 'xiaoying',
}
```

#### 返回值
```javascript
{
    "安徽省": [
        "安庆市",
        ...
    ],
    ...
}
```


### 3. 计算分期金额


#### 请求方式
    
    pay/installment/calc

#### 请求参数
``` javascript
{
    partner: 'xiaoying',
    order_id: 11243,                    // 订单id
    amount: 110000,                     // 借款金额 单位 分
}
```

#### 返回值
```javascript
{
    6: {
        periods: 6,
        total: 211530,                  // 应还总额
        period_pay: 35255,              // 每期应还
    },
    12: {
        periods: 12,
        total: 221748,                  // 应还总额
        period_pay: 18479,              // 每期应还
    }
}
```


### 4. 注册并实名认证

#### 请求方式

    pay/installment/register

#### 请求参数
``` javascript
{
    partner: 'xiaoying',
    order_id: 1231112,
    name: "***",                        // 姓名
    id_card: "****....",                // 身份证号
    phone: "18899990000",
    password: "123456",
}
```

### 返回值
```javascript
{
    third_uid: '11223345',
    borrower_id: 23,
}
```


### 5. 用户信息填写

#### 请求方式
    
    pay/installment/userinfo

#### 请求参数
``` javascript
{
    partner: 'xiaoying',
    borrower_id: 23,
    user_info: {
        name: "***",
        gender: "男",                       // 男, 女
        age: 23,
        mirrage: "未婚",
        education: '本科',
        province: "安徽省",
        city: "安庆市",
        district: "我也不知道哪个区, 随便填",
        address: "....",
    }
    contacts: [
        {
            contact_type: 'immediate',
            name: "***",
            relation: "父子",
            phone: "1223333222"
        },
        {
            contact_type: 'contact',
            name: "***",
            relation: "朋友",
            phone: "1223333222"
        },
    ]
    id_card: {
        id_card_front: 'http://gmei......',         // 身份证正面
        id_card_back: 'http://gmei......',          // 身份证背面
        id_card_hold: 'http://gmei......',          // 身份证手持照
    }
}
```

#### 返回值
```javascript
{
}
```


### 6. 绑定代扣银行卡预校验

#### 请求方式
    
    pay/installment/check_bank

#### 请求参数
``` javascript
{
    partner: 'xiaoying',
    borrower_id: 123112,
    name: "***",                            // 持卡人
    bank_code: "ICBC",
    province: "北京",
    city: "三亚",
    card: '62193....',                      // 银联储蓄卡号
    phone: "18823334455",                   // 银行预留手机号
}
```

#### 返回值
```javascript
{
    ticket: '2233344334',                   // 验证凭证
    bind_id: 123,
}
```

### 7. 绑定银行卡

#### 请求方式
    
    pay/installment/bind_bank

#### 请求参数
``` javascript
{
    partner: 'xiaoying',
    bind_id: 1234,
    sms_code: '123123',                     // 手机收到的验证码
}
```

#### 返回值
```javascript
{
}
```



### 8. 申请借款

#### 请求方式
    
    pay/installment/loan

#### 请求参数
``` javascript
{
    partner: 'xiaoying',
    borrower_id: 23231,
    order_id: 23344455,                     // 订单id
    periods: 6,                             // 期数
}
```

#### 返回值
```javascript
{
    loan_id: 1234455,                       // 借款协议号
    installment_id: 45,                     // 借款单ID
}
```


### 9. 查询借款状态

#### 请求方式
    
    pay/installment/status

#### 请求参数
``` javascript
{
    partner: 'xiaoying',
    installment_id: 45,
}
```

#### 返回值
```javascript
{
    status: 1,                                  // 0:待提交审核 10:待风控审核 50:审核通过 60:审核拒绝 70:待补件 100:借款成功 120:放款失败
    description: '审核结果的简要描述',
    supply_code: 1,                             // 补件编码, 待补件状态才有补件编码
    /*
    1 身份证正面照缺失
    2 身份证正面照不清晰
    3 身份证反面照缺失
    4 身份证反面照不清晰
    5 手持身份证照片缺失
    6 手持身份证照片不清晰
    */
}
```

### 10. 补充审核资料


#### 请求方式
    
    pay/installment/replenish

#### 请求参数
``` javascript
{
    partner: 'xiaoying',
    installment_id: 123,
    card: {
        id_card_front: 'http://gmei......',         // 身份证正面
        id_card_back: 'http://gmei......',          // 身份证背面
        id_card_hold: 'http://gmei......',          // 身份证手持照
    }
}
```

#### 返回值
```javascript
{
}
```

### 11. 退款或放弃贷款


#### 请求方式
    
    pay/installment/refund

#### 请求参数
``` javascript
{
    partner: 'xiaoying',
    installment_id: 123,
}
```

#### 返回值
```javascript
{
}
```


### 12. 用户借款信息

#### 请求方式

    pay/installment/user

#### 请求参数
```javascript
{
    partner: 'xiaoying',
    borrower_id: 123456,
}
```

#### 返回值
```javascript
{
    register: true,                                     // 已经注册过
    borrower_id: 223,                                   // 如果用户已经注册过
    user_info: true,                                    // 已填写个人信息
    bind_bank: true,                                    // 已绑定银行卡
    bind_id: 44,
    installment_id: 34,                                 // 如果已借款则有借款单
    ...                                                 // 其他信息暂无, 可提供借款人相关其他信息
}
```
