#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   16/06/13 21:19:05
#   Desc    :   借款相关接口测试
#

import json
import datetime

import request
import settings


req = request.Request('apiBorrower')


class RunHelper(object):

    def run(self):
        print(self.params)
        content = req.handler(self.endpoint)(**self.params)
        raw = json.loads(content)
        print(raw)


class Register(RunHelper):

    def __init__(self):
        self.params = {
            'mobile': '18518756705',
            'password': '88889999',
            'channel': settings.CHANNEL,
            #'partnerId': 'wx12313',
            'idType': 1,
            'idNo': '412725199208183032',
            'name': '丁英才',
            'sendPassword': 0,
        }
        self.endpoint = 'registerAndVerify'


class CheckBank(RunHelper):

    def __init__(self):
        self.params = {
            'uid': settings.UID,
            'bank': 'CCB',
            'cardNo': '6225096554333',
            'phone': '18518756705',
            'province': '广东',
            'city': '广州',
        }
        self.endpoint = 'checkSecureBank'
        pass


class BindBank(RunHelper):

    def __init__(self):
        self.params = {
            'uid': settings.UID,
            'verifiedData': json.dumps(settings.verifiedData),
            'smsCode': settings.SMSCODE
        }
        self.endpoint = 'bindSecureBank'
        pass


class CreateLoad(RunHelper):

    def __init__(self):
        self.params = {
            'uid': settings.UID,
            'type': 121,
            'applyTime': int(datetime.datetime.now().timestamp()),
            'amount': 10000,
            'periodType': 31,
            'periods': 6,
            'repayType': 3,
            'extendInfo': {
                'loanApplyNo': '923123998844'
            }
        }
        self.endpoint = 'createLoan'
        pass


class LoanDetail(RunHelper):

    def __init__(self):
        self.params = {
            'uid': settings.UID,
            'loanOrderId': settings.LOANORDERID,
        }
        self.endpoint = 'loanDetail'


class LoadAuditDetail(RunHelper):

    def __init__(self):
        self.params = {
            'uid': settings.UID,
            # 'loanId': settings.LOANID,
            'loanOrderId': settings.LOANORDERID,
        }
        self.endpoint = 'loanAuditDetail'
        pass


class ConfirmLoan(RunHelper):

    def __init__(self):
        self.params = {
            'uid': settings.UID,
            'loanOrderId': settings.LOANORDERID,
            'result': 1,
        }
        self.endpoint = 'confirmLoan'
        pass


class t(RunHelper):

    def __init__(self):
        self.params = {
            '': 1,
        }
        self.endpoint = ''
        pass


class RepayLoan(RunHelper):

    def __init__(self):
        self.params = {
            'uid': settings.UID,
            'loanOrderId': settings.LOANORDERID,
            'isAdvance': 0,
        }
        self.endpoint = 'repayloan'
        pass


class LoanRepayDetail(RunHelper):

    def __init__(self):
        self.params = {
            'uid': settings.UID,
            'loanOrderId': settings.LOANORDERID,
            'isAdvance': 0,
        }
        self.endpoint = 'loanRepayDetail'
        pass


