#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   16/06/12 19:34:08
#   Desc    :   加密解密请求
#

import json
import base64
import hashlib

from Crypto import Random
from Crypto.PublicKey import RSA
from Crypto.Cipher import ARC4
from Crypto.Cipher import PKCS1_v1_5
import requests

import settings


class Request(object):

    def __init__(self, subject):
        self.subject = subject
        yingtz_key = base64.b64decode(open(settings.YINGTZ_KEY_TEST).read())
        self.yingtz_key = RSA.importKey(yingtz_key)
        self.gmei_key = RSA.importKey(open(settings.GMEI_PRIVATE_KEY_PKCS8).read())
        pass

    def handler(self, endpoint):

        def _fetch(**kwargs):
            params = self.encrypt_param(kwargs)
            url = settings.BASE_URL.format(
                subject=self.subject, endpoint=endpoint)
            resp = requests.post(url, data=params)
            content = self.decrypt(resp.content)
            return str(content, encoding='utf8')
        return _fetch

    def encrypt_param(self, params):
        one_time_key = Random.new().read(128)
        rsa_cipher = PKCS1_v1_5.new(self.yingtz_key)
        key1 = base64.b16encode(rsa_cipher.encrypt(one_time_key[:117]))
        key2 = base64.b16encode(rsa_cipher.encrypt(one_time_key[-11:]))

        content = json.dumps(params)
        r4_cipher = ARC4.new(one_time_key)
        raw_content = r4_cipher.encrypt(content)
        encoded_content = base64.b16encode(raw_content)

        sign = hashlib.md5(raw_content+settings.MD5KEY).hexdigest()
        return {
            'key': str(key1+key2, encoding='utf8'),
            'sign': sign,
            'content': str(encoded_content, encoding='utf8'),
            'partner': settings.PARTNER
        }

    def decrypt(self, raw):
        resp = json.loads(str(raw, encoding='utf8'))
        key = base64.b16decode(resp['key'].upper())
        raw_content = base64.b16decode(resp['content'].upper())
        self.check_sign(raw_content, resp['sign'])

        sentinel = object()
        cipher = PKCS1_v1_5.new(self.gmei_key)
        key1 = cipher.decrypt(key[:256], sentinel)
        key2 = cipher.decrypt(key[-256:], sentinel)
        if key1 is sentinel or key2 is sentinel:
            raise ValueError('Decrypt Error')
        content = ARC4.new(key1+key2).decrypt(raw_content)
        return content

    def check_sign(self, content, sign):
        cal_sign = hashlib.md5(content+settings.MD5KEY).hexdigest()
        if sign != cal_sign:
            raise ValueError('check sign error')
