//
//  ReapetWork.swift
//  AutoJira
//
//  Created by wangyang on 2019/2/28.
//  Copyright © 2019 wangyang. All rights reserved.
//

import Foundation
import Kanna
import ReactiveCocoa


struct RepeatedWork {
    static var sprint: Sprint?


    // url是“开发与测试资源安排”中的迭代文件
    static func fuckit(on sprintUrl: String) {
        let url = URL(string: sprintUrl)!
        var request = URLRequest(url: url)
        request.httpMethod = "GET"
        URLSession.shared.dataTask(with: request) { (data, response, error) in
            DispatchQueue.main.async {
                if data != nil {
                    doTheRepeatedWork(data!)
                } else {
                    Log.append(error)
                }
            }
        }.resume()
    }

    static func doTheRepeatedWork(_ data: Data) {
        Log.append("开始重复工作")
        guard let html = String(data: data, encoding: .utf8) else {
            return
        }
        guard let doc = try? HTML(html: html, encoding: .utf8) else {
            return
        }

        // 期望在这儿只得到主需求的列表
        // 但是doc.xpath("//td[@data-content-id]")仍然得到了所有的
        let obj = doc.xpath("//*[@id=\"main-content\"]/div[2]/table/tbody//td[@data-content-id]")
        if obj.count == 0 {
            Log.append("没有需要列表\nhtml")
            return
        }
        // 此处的每一个node就是一个需求，可以使用node.toHTML来查看其内容
        for node in obj.makeIterator() {
            let page = Page(page: node)

            if !page.isValide() {
                Log.append("\(node.toHTML!) page 信息有问题")
                continue
            }

            if let story = Story.createStory(with: page.title) {
                page.story = story
            } else {
                Log.append("\(node.toHTML!) story创建出错")
                continue
            }

            page.story.connect(to: page.pageId, with: page.lastFetchTime)
            if let foId = page.fo?.id {
                page.story.editStoryInfo(assignee: foId)
            } else {
                Log.append("\(node.toHTML!) 没有正确修改story")
            }
            page.story.createSubtask(page: page)
        }
    }
}
