//
//  Utils.swift
//  AutoJira
//
//  Created by wangyang on 2019/2/27.
//  Copyright © 2019 wangyang. All rights reserved.
//

import Foundation

extension URLRequest {
    static var jiraSession: String?

    mutating func setJiraCookie() {
        setValue("AJS.conglomerate.cookie=\"|hipchat.inapp.links.first.clicked.wangyang=false\"; atlassian.xsrf.token=BR38-RKGV-NWEL-Y2GE|59c084face9db734b606415629e67f572939e829|lin; JSESSIONID=A273C4AAFA2594506ABA814082718E0E; jira.editor.user.mode=wysiwyg", forHTTPHeaderField: "Cookie")
    }

    func sync(with completionHandler: @escaping (Data?, URLResponse?, Error?) -> Void) {
        let semaphore = DispatchSemaphore(value: 0)
        let dataTask = URLSession.shared.dataTask(with: self) { (data, response, error) in
            completionHandler(data, response, error)
            semaphore.signal()
        }
        dataTask.resume()
        _ = semaphore.wait(timeout: .distantFuture)
    }
}
