//
//  ViewController.swift
//  AutoJira
//
//  Created by wangyang on 2019/2/25.
//  Copyright © 2019 wangyang. All rights reserved.
//

import Cocoa
import Kanna

enum SprintState: String {
    case future = "FUTURE"
    case active = "ACTIVE"
    case none = ""
}

struct Sprint {
    let name: String
    let id: Int
    let stateKey: SprintState

    init(dic: [String: Any]) {
        if let name = dic["name"] as? String,
            let id = dic["id"] as? Int,
            let stateKey = dic["stateKey"] as? String,
            let s = SprintState(rawValue: stateKey) {
            self.name = name
            self.id = id
            self.stateKey = s
        } else {
            name = ""
            id = 0
            stateKey = .none
        }
    }
}

class JIRA: NSObject {
    var jiraProjectId: String = ""
    var sprints: [Sprint] = []
    var currentSprint: Sprint?
    var subtask_id: String = ""
    convenience init(jiraProjectId: String, sprints: [Sprint]) {
        self.init()
        self.jiraProjectId = jiraProjectId
        self.sprints = sprints

        // like sub task 10302
        // gengmei sub task 10003
        if jiraProjectId == "10108" {
            // 更美
            subtask_id = "10003"
        } else {
            // like
            subtask_id = "10302"
        }
    }
}

class ViewController: NSViewController {
    @IBOutlet var logTextView: NSTextView!
    @IBOutlet weak var urlTextField: NSTextField!
    @IBOutlet weak var versionPopup: NSPopUpButton!
    @IBOutlet weak var segment: NSSegmentedControl!

    var jiraProjects: [Int: JIRA] = [:]

    override func viewDidLoad() {
        super.viewDidLoad()
        Login.loginWiki()
        Login.loginJira()
        fetchJiraProjects()
        segment.selectedSegment = 0
        switchProject(segment)
    }

    // 参考"获取迭代列表.md"
    func fetchJiraProjects() {
        var gengmeiSprints: [Sprint] = []
        var likeSprints: [Sprint] = []
        let url = URL(string: "http://jira.wanmeizhensuo.com/rest/greenhopper/1.0/sprint/picker?query=&_=1552128647090")!
        var request = URLRequest(url: url)
        request.httpMethod = "GET"
        request.sync { [weak self] (data, response, error) in
            if data == nil {
                Log.append(error)
                return
            }
            if self == nil {
                Log.append("fetchSprintList self 为空")
                return
            }

            if let json = (try? JSONSerialization.jsonObject(with: data!, options: JSONSerialization.ReadingOptions.allowFragments)) as? [String: Any] {
                guard let sprints = json["suggestions"] as? [[String: Any]] else {
                    Log.append("json中没有suggestions")
                    return
                }
                for sprintDic in sprints {
                    if let boardName = sprintDic["boardName"] as? String {
                        if boardName == "Alpha" {
                            let sprint = Sprint(dic: sprintDic)
                            likeSprints.append(sprint)
                        } else if boardName == "USER board" {
                            let sprint = Sprint(dic: sprintDic)
                            gengmeiSprints.append(sprint)
                        }
                    }
                }
            } else {
                Log.append("获取迭代列表失败：\n\(response.debugDescription)")
            }
        }

        // project AL: 10500
        // project USER: 10108
        jiraProjects = [0: JIRA(jiraProjectId: "10108", sprints: gengmeiSprints),
                        1: JIRA(jiraProjectId: "10500", sprints: likeSprints)]
    }

    @IBAction func switchProject(_ sender: NSSegmentedControl) {
        versionPopup.removeAllItems()
        versionPopup.addItem(withTitle: "未选择版本号")
        RepeatedWork.jira = jiraProjects[sender.indexOfSelectedItem]!
        versionPopup.addItems(withTitles: RepeatedWork.jira!.sprints.map { return $0.name })
    }

    @IBAction func versionSelectionAction(_ sender: NSPopUpButton) {
        if sender.indexOfSelectedItem > 0 {
            RepeatedWork.jira?.currentSprint = RepeatedWork.jira!.sprints[sender.indexOfSelectedItem - 1]
        } else {
            RepeatedWork.jira = nil
        }
    }

    @IBAction func OKAction(_ sender: Any) {
        if RepeatedWork.jira == nil {
            Log.append("先选择版本号")
            return
        }
        if urlTextField.stringValue.count == 0 ||
            urlTextField.stringValue.count == 0 {
            Log.append("需求列表地址没有填写")
            return
        }
        RepeatedWork.fuckit(on: urlTextField.stringValue)
    }
}

class Log: NSObject {
    static func append(_ logText: String) {
        DispatchQueue.main.async {
            if let controller = NSApplication.shared.keyWindow?.contentViewController as? ViewController {
                let textStorage = controller.logTextView.textStorage!
                textStorage.append(NSAttributedString(string: "\n"))
                textStorage.append(NSAttributedString(string: logText))
            }
        }
    }

    static func append(_ error: Error?) {
        DispatchQueue.main.async {
            if let err = error as NSError? {
                append(err.localizedDescription)
            }
        }

    }
}
