//
//  Page.swift
//  AutoJira
//
//  Created by wangyang on 2019/2/26.
//  Copyright © 2019 wangyang. All rights reserved.
//

import Cocoa
import Kanna
import ReactiveSwift

struct People {
    var name: String
    var id: String
}
/*
 可以使用html属性进一步来查看当前所代码的html代码。
 */
class Page: NSObject {
    var pageId: String = ""
    var title: String = ""
    var story: Story!
    var lastFetchTime: String = ""
    var pageUrl: String = ""
    let session = URLSession.shared
    var html: HTMLDocument?
    var fo: People?
    // developers包括各端开发人员，测试人员
    var developers: [People] = []

    convenience init(page: Kanna.XMLElement) {
        self.init()
        pageId = page["data-content-id"]!
        title = page.text!
        pageUrl = "http://wiki.wanmeizhensuo.com/pages/viewpage.action?pageId=" + pageId
        html = loadHTML()

        // 这个逻辑是模仿wiki页面中的javasript中的已有的逻辑
        if let meta = html?.at_xpath("//meta[@name='confluence-request-time']") {
            lastFetchTime = meta["content"]!
        } else {
            lastFetchTime = String(Int(Date().timeIntervalSince1970 * 1000))
        }

        // 核心是得到developers，其它都是错误处理
        guard let tableTr = html?.xpath("//*[@id=\"main-content\"]/div[1]/div/table/tbody/tr") else {
            Log.append("没有得到需求文档的table")
            return
        }

        // 循环table中的每一行，如果该行是FO或者开发这一类的，就进行人员解析
        for tr in tableTr.makeIterator() {
            guard let th = tr.at_xpath("th")?.innerHTML else {
                Log.append("\(tr.toHTML!) table tr/th中没有span")
                continue
            }
            if th.contains("FO")  {
                if let user = getUser(tr: tr).first {
                    fo = user
                } else {
                    Log.append("\(tr.toHTML!) FO 没有正确生成")
                    continue
                }
            } else if th.contains("测试") || th.contains("开发") || th.contains("数据") {
                developers.append(contentsOf: getUser(tr: tr))
            }
        }

        Log.append("成功得到所有人员")
    }

    // 从table的行中解析人员
    func getUser(tr: Kanna.XMLElement) -> [People] {
        let userHtmls = tr.xpath("td//a")
        var users: [People] = []
        for html in userHtmls.makeIterator() {
            if let name_id = html["data-username"], let name = html.innerHTML {
                users.append(People(name: name, id: name_id))

            } else {
                if html.toHTML != nil {
                    Log.append("\(html.toHTML!) 没有成功解析")
                    continue
                }
                Log.append("\(html)没有成功解析")
            }
        }
        return users
    }

    func isValide() -> Bool {
        if html == nil {
            Log.append("\(pageUrl) 未正常解析")
            return false
        }

        Log.append("创建Page成功: \(title)")
        return true
    }

    // 下载需求页面，从中得到必要的信息
    func loadHTML() -> HTMLDocument? {
        let url = URL(string: pageUrl)!
        var request = URLRequest(url: url)
        request.httpMethod = "GET"
        var html: HTMLDocument?
        request.sync { (data, response, error) in
            if data == nil {
                html = nil
                return
            }
            guard let htmlString = String(data: data!, encoding: .utf8) else {
                html = nil
                return
            }
            html = try? HTML(html: htmlString, encoding: .utf8)
        }

        return html
    }
}


