//
//  Wiki.swift
//  AutoJira
//
//  Created by wangyang on 2019/2/27.
//  Copyright © 2019 wangyang. All rights reserved.
//

import Foundation
import Kanna

class Story: NSObject {

    var storyKey: String = ""
    var storyId: String = ""
    var summary: String = ""
    var pid: String = ""
    var subtask_atl_token = ""
    var subtask_formToken = ""

    convenience init(storyKey: String, storyId: String) {
        self.init()
        self.storyId = storyId
        self.storyKey = storyKey
    }

    /// 创建story
    ///
    /// - Parameter page: Page实例
    /// - Returns: storyKey
    static func createStory(with title: String, jiraProjectId: String) -> Story? {
        Log.append("创建story")
        let url = URL(string: "http://wiki.wanmeizhensuo.com/rest/jira-integration/1.0/issues?applicationId=54ed5447-b029-3ef0-b638-681b4647313b")!
        var request = URLRequest(url: url)
        request.httpMethod = "POST"
        
        request.setValue("application/json", forHTTPHeaderField: "Content-Type")
        let jsonDic = ["issues": [["fields":["project":["id":RepeatedWork.jira!.jiraProjectId],"issuetype":["id":"10001"],"summary": title]]]]
        request.httpBody = try? JSONSerialization.data(withJSONObject: jsonDic, options: [])
        var story: Story?
        request.sync { (data, response, error) in
            if data == nil {
                Log.append(error)
                return
            }
            if let json = (try? JSONSerialization.jsonObject(with: data!, options: JSONSerialization.ReadingOptions.allowFragments)) as? [String: Any],
                let issues = json["issues"] as? [Any], issues.count > 0,
                let issueInfo = issues[0] as? [String: Any],
                let issue = issueInfo["issue"] as? [String: Any],
                let key = issue["key"] as? String,
                let id = issue["id"] as? String {
                story = Story(storyKey: key, storyId: id)
                story?.summary = title
                Log.append("创建story请求成功：\(story!.storyKey)")
            } else {
                Log.append("创建story请求失败：\n\(response.debugDescription)")
            }
        }
        return story
    }

    /// 关联文档与story
    func connect(to pageId: String, with pageLastFetchTime: String) {
        Log.append("关联story与wiki")
        let url = URL(string: "http://wiki.wanmeizhensuo.com/rest/highlighting/1.0/insert-storage-fragment")!
        var request = URLRequest(url: url)
        request.httpMethod = "POST"
        request.setValue("application/json", forHTTPHeaderField: "Content-Type")
        let bodyString = "{\"pageId\":\"\(pageId)\",\"selectedText\":\"项目背景\",\"index\":0,\"numMatches\":1,\"lastFetchTime\":\(pageLastFetchTime),\"xmlModification\":\"<ac:macro ac:name='jira'><ac:parameter ac:name='showSummary'>false</ac:parameter><ac:parameter ac:name='server'>JIRA</ac:parameter><ac:parameter ac:name='serverId'>54ed5447-b029-3ef0-b638-681b4647313b</ac:parameter><ac:parameter ac:name='key'>\(storyKey)</ac:parameter></ac:macro>\"}"
        let data = bodyString.data(using: .utf8)
        request.httpBody = data

        request.sync { (data, response, error) in
            if error != nil {
                Log.append(error)
                return
            }
            if let json = (try? JSONSerialization.jsonObject(with: data!, options: JSONSerialization.ReadingOptions.allowFragments)) as? Bool {
                if json {
                    Log.append("关联story与wiki成功")
                } else {
                    Log.append("关联story与wiki失败，很有可能是文档中没有\"项目背景\"四个字。response：\n \(response.debugDescription)")
                }
                return
            } else {
                Log.append("关联story与wiki失败，json没有正常解析。response：\n \(response.debugDescription)")
            }
        }
    }

    /// 修改story的“指派人”
    /// 修改story所在的sprint
    func editStoryInfo(assignee: String) {
        Log.append("编辑story的assign与sprint")
        let url = URL(string: "http://jira.wanmeizhensuo.com/secure/QuickEditIssue.jspa?issueId=\(storyId)&decorator=none")!
        var request = URLRequest(url: url)
        request.httpMethod = "POST"
        request.setValue("application/x-www-form-urlencoded", forHTTPHeaderField: "Content-Type")

        guard let formString = getEditIssueFormdata(assignee: assignee) else {
            Log.append("editStoryInfo 失败")
            return
        }

        let formData = formString.data(using: .utf8)
        request.httpBody = formData
        request.sync { (data, response, error) in
            if error != nil {
                Log.append(error)
            } else {
                Log.append("修改issue成功")
            }
        }
    }

    /// 先模拟点击修改，以获取formToken、atl_token
    func getEditIssueFormdata(assignee: String) -> String? {
        let url = URL(string: "http://jira.wanmeizhensuo.com/secure/QuickEditIssue!default.jspa?issueId=\(self.storyId)&decorator=none")!
        var request = URLRequest(url: url)
        request.httpMethod = "POST"
        var json: [String: Any]?
        request.sync { (data, response, error) in
            if data == nil {
                Log.append(error)
                return
            }
            json = (try? JSONSerialization.jsonObject(with: data!, options: JSONSerialization.ReadingOptions.allowFragments)) as? [String: Any]
        }

        if json == nil {
            Log.append("secure/QuickEditIssue出错")
            return nil
        }

        guard let formToken = json!["formToken"] as? String else {
            Log.append("formToken出错")
            return nil
        }

        guard let atl_token = json!["atl_token"] as? String else {
            Log.append("atl_token出错")
            return nil
        }

        let formData = "id=\(storyId)&atl_token=\(atl_token)&formToken=\(formToken)&assignee=\(assignee)&customfield_10005=\(RepeatedWork.jira!.currentSprint!.id)&isCreateIssue=false&isEditIssue=true&summary=\(summary)&issuetype=10001&reporter=wangyang&description=开始时间%2B开发人员%2B任务名称%2B预计开发时间"
        return formData
    }

    /// 根据story创建每一个人的subtask
    ///
    /// - Parameter page: page实例page: Page
    func createSubtask(page: Page) {
        Log.append("根据story创建subtask")
        prepareForSubtask()

        for assignee in page.developers {
            let summary = "开始时间%2B\(assignee.name)%2B\(self.summary)%2B预计开发时间"
            quickCreateSubtask(assignee: assignee.id, summary: summary)
        }
        if let foid = page.fo?.id {
            quickCreateSubtask(assignee: foid, summary: "dev环境联调：xx号")
            quickCreateSubtask(assignee: foid, summary: "Demo时间：xx号")
        }

    }

    func quickCreateSubtask(assignee: String, summary: String) {

        let url = URL(string: "http://jira.wanmeizhensuo.com/secure/QuickCreateIssue.jspa?decorator=none")!
        var request = URLRequest(url: url)
        request.httpMethod = "POST"
        request.setValue("application/x-www-form-urlencoded", forHTTPHeaderField: "Content-Type")
        let formString = "pid=\(pid)&issuetype=10003&parentIssueId=\(storyId)&atl_token=\(subtask_atl_token)&formToken=\(subtask_formToken)&summary=\(summary)&isCreateIssue=true&assignee=\(assignee)&reporter=wangyang&priority=3&issuelinks=issuelinks&issuelinks-linktype=blocks&isCreateIssue=true&isEditIssue=false&"

        let formData = formString.data(using: .utf8)
        request.httpBody = formData
        request.sync { (data, response, error) in
            if error != nil {
                Log.append(error)
            } else {
                Log.append("创建subtask成功")
            }
        }
    }

    // 得到一些token，pid等信息
    func prepareForSubtask() {
        let url = URL(string: "http://jira.wanmeizhensuo.com/secure/QuickCreateIssue!default.jspa?parentIssueId=\(self.storyId)&decorator=none")!
        var request = URLRequest(url: url)
        request.httpMethod = "POST"
        var json: [String: Any]?
        request.sync { (data, response, error) in
            if data == nil {
                Log.append(error)
                return
            }
            json = (try? JSONSerialization.jsonObject(with: data!, options: JSONSerialization.ReadingOptions.allowFragments)) as? [String: Any]
        }

        if json == nil {
            Log.append("secure/QuickEditIssue出错")
            return
        }

        guard let formToken = json!["formToken"]  as? String else {
            Log.append("formToken出错")
            return
        }
        self.subtask_formToken = formToken

        guard let atl_token = json!["atl_token"] as? String else {
            Log.append("atl_token出错")
            return
        }
        self.subtask_atl_token = atl_token

        guard let fields = json!["fields"] as? [[String: Any]] else {
            Log.append("fields出错")
            return
        }

        if fields.count == 0 {
            Log.append("fields.count == 0 出错")
            return
        }

        let firstField = fields[0]
        let editHtml = firstField["editHtml"] as! String
        guard let projectHtml = try? HTML(html: editHtml, encoding: .utf8) else {
            Log.append("projectHtml出错")
            return
        }

        guard let input = projectHtml.at_xpath("//input") else {
            return
        }

        guard let pid = input["value"] else {
            return
        }
        self.pid = pid
    }
}

