//
//  ReapetWork.swift
//  AutoJira
//
//  Created by wangyang on 2019/2/28.
//  Copyright © 2019 wangyang. All rights reserved.
//

import Foundation
import Kanna

class JiraAutomator: NSObject {

    static let shared = JiraAutomator()
    var jira: JiraProject?
    var currentSprint: Sprint?
    
    let projects = [JiraProjectType.gengmei: JiraProject(projectType: .gengmei),
                    JiraProjectType.like: JiraProject(projectType: .like)]

    // 参考"获取迭代列表.md"
    func fetchJiraSprints() {
        let url = URL(string: "http://jira.wanmeizhensuo.com/rest/greenhopper/1.0/sprint/picker?query=&_=1552128647090")!
        var request = URLRequest(url: url)
        request.httpMethod = "GET"
        request.sync { [weak self] (data, response, error) in
            if data == nil {
                Log.append(error)
                return
            }
            if self == nil {
                Log.append(error: "fetchSprintList self 为空")
                return
            }

            if let json = (try? JSONSerialization.jsonObject(with: data!, options: JSONSerialization.ReadingOptions.allowFragments)) as? [String: Any] {
                guard let sprints = json["suggestions"] as? [[String: Any]] else {
                    Log.append(error: "json中没有suggestions")
                    return
                }
                for sprintDic in sprints {
                    if let boardName = sprintDic["boardName"] as? String {
                        if boardName == "Alpha" {
                            let sprint = Sprint(dic: sprintDic)
                            self!.projects[JiraProjectType.like]!.sprints.append(sprint)
                        } else if boardName == "USER board" {
                            let sprint = Sprint(dic: sprintDic)
                            self!.projects[JiraProjectType.gengmei]!.sprints.append(sprint)
                        }
                    }
                }
            } else {
                Log.append(error: "获取迭代列表失败：\n\(response.debugDescription)")
            }
        }
    }

    func switchProject(type: JiraProjectType) {
        self.jira = projects[type]
    }

    // url是“开发与测试资源安排”中的迭代文件
    func start(on sprintUrl: String) {
        let url = URL(string: sprintUrl)!
        var request = URLRequest(url: url)
        request.httpMethod = "GET"
        URLSession.shared.dataTask(with: request) { [weak self] (data, response, error) in
            DispatchQueue.main.async {
                if data != nil {
                    self?.doTheRepeatedWork(data!)
                } else {
                    Log.append(error)
                }
            }
        }.resume()
    }

    func doTheRepeatedWork(_ data: Data) {
        guard let html = String(data: data, encoding: .utf8) else {
            return
        }
        guard let doc = try? HTML(html: html, encoding: .utf8) else {
            return
        }

        // 期望在这儿只得到主需求的列表
        // 但是doc.xpath("//td[@data-content-id]")仍然得到了所有的
        //
        let obj = doc.xpath("//*[@id=\"main-content\"]/div[2]/table/tbody//td[@data-content-id]")
        if obj.count == 0 {
            Log.append(error: "根据XPath没有找到需求。一般来说是XPath出错，原始html内容为\(html)")
            return
        }
        // 此处的每一个node就是一个需求，可以使用node.toHTML来查看其内容
        var index = 1
        Log.append("一共\(obj.count)个需求")
        for node in obj.makeIterator() {
            Log.append("开始处理第\(index)个")

            let page = Page(page: node)
            if !page.isValide() {
                Log.append(error: "\(page.title): 验证未通过")
                continue
            }

            if page.hasCreateStory() {
                Log.append("\(page.title): 已经创建story，跳过其它步骤")
                continue
            }

            if let story = Story.createStory(with: page.title) {
                page.story = story
            } else {
                Log.append(error: "\(page.title): story创建出错")
                continue
            }
            Log.append("story创建完成")
            page.story.connect(to: page.pageId, with: page.lastFetchTime)
//            if let foId = page.fo?.id {
//                page.story.editStoryInfo(assignee: foId)
//            } else {
//                Log.append(error: "\(node.toHTML!) 没有正确修改story")
//            }
//            page.story.createSubtask(page: page)

            index += 1
        }
    }
}
