//
//  Jira.swift
//  AutoJira
//
//  Created by wangyang on 2019/3/28.
//  Copyright © 2019 wangyang. All rights reserved.
//

import Cocoa

class JiraProject: NSObject {
    var id: String = ""
    var sprints: [Sprint] = []
    
    var subtask_id: String = ""

    convenience init(projectType: JiraProjectType) {
        self.init()
        self.id = projectType.rawValue
        self.subtask_id = projectType.subtaskId()
    }
}

enum JiraProjectType: String {
    case like = "10500"
    case gengmei = "10108"

    func subtaskId() -> String {
        switch self {
        case .like:
            return "10302"
        case .gengmei:
            return "10003"
        }
    }
}

enum SprintState: String {
    case future = "FUTURE"
    case active = "ACTIVE"
    case none = ""
}

struct Sprint {
    let name: String
    let id: Int
    let stateKey: SprintState

    init(dic: [String: Any]) {
        if let name = dic["name"] as? String,
            let id = dic["id"] as? Int,
            let stateKey = dic["stateKey"] as? String,
            let s = SprintState(rawValue: stateKey) {
            self.name = name
            self.id = id
            self.stateKey = s
        } else {
            name = ""
            id = 0
            stateKey = .none
        }
    }
}
