//
//  ViewController.swift
//  AutoJira
//
//  Created by wangyang on 2019/2/25.
//  Copyright © 2019 wangyang. All rights reserved.
//

import Cocoa
import Kanna


class ViewController: NSViewController {
    @IBOutlet var logTextView: NSTextView!
    @IBOutlet weak var urlTextField: NSTextField!
    @IBOutlet weak var sprintPopup: NSPopUpButton!
    @IBOutlet weak var segment: NSSegmentedControl!

    override func viewDidLoad() {
        super.viewDidLoad()
        Login.loginWiki()
        Login.loginJira()
        JiraAutomator.shared.fetchJiraSprints()
        segment.selectedSegment = 0
        switchProject(segment)
    }

    @IBAction func switchProject(_ sender: NSSegmentedControl) {
        sprintPopup.removeAllItems()
        sprintPopup.addItem(withTitle: "未选择版本号")
        if sender.indexOfSelectedItem == 0 {
            JiraAutomator.shared.switchProject(type: .gengmei)
        } else {
            JiraAutomator.shared.switchProject(type: .like)
        }
        sprintPopup.addItems(withTitles: JiraAutomator.shared.jira!.sprints.map { return $0.name })
    }

    @IBAction func sprintSelectionAction(_ sender: NSPopUpButton) {
        if sender.indexOfSelectedItem > 0 {
            JiraAutomator.shared.currentSprint? = JiraAutomator.shared.jira!.sprints[sender.indexOfSelectedItem - 1]
        } else {
            JiraAutomator.shared.currentSprint = nil
        }
    }

    @IBAction func OKAction(_ sender: Any) {
        if sprintPopup.indexOfSelectedItem == 0 {
            Log.append(error: "先选择版本号")
            return
        }
        if urlTextField.stringValue.count == 0 {
            Log.append(error: "填写需求列表地址")
            return
        }
        JiraAutomator.shared.start(on: urlTextField.stringValue)
    }
}

class Log: NSObject {
    static func append(error logText: String) {
        DispatchQueue.main.async {
            if let controller = NSApplication.shared.keyWindow?.contentViewController as? ViewController {
                let textStorage = controller.logTextView.textStorage!
                let log = NSMutableAttributedString(string: "\n" + logText, attributes: [NSAttributedString.Key.foregroundColor : NSColor.red])
                textStorage.append(log)
            }
        }
    }

    static func append(_ logText: String) {
        DispatchQueue.main.async {
            if let controller = NSApplication.shared.keyWindow?.contentViewController as? ViewController {
                let textStorage = controller.logTextView.textStorage!
                let log = NSMutableAttributedString(string: "\n" + logText, attributes: [NSAttributedString.Key.foregroundColor : NSColor.black])
                textStorage.append(log)
            }
        }
    }

    static func append(_ error: Error?) {
        DispatchQueue.main.async {
            if let err = error as NSError? {
                append(error: err.localizedDescription)
            }
        }

    }
}
