//
//  Page.swift
//  AutoJira
//
//  Created by wangyang on 2019/2/26.
//  Copyright © 2019 wangyang. All rights reserved.
//

import Cocoa
import Kanna
import ReactiveSwift

/*
 可以使用html属性进一步来查看当前所代码的html代码。
 */
class Page: NSObject {
    var pageId: String = ""
    var title: String = ""
    var story: Story!
    var lastFetchTime: String = ""
    var pageUrl: String = ""
    let session = URLSession.shared
    var html: HTMLDocument?
    var fo: String = ""
    var testers: [String] = []
    var developers: [String] = []

    convenience init(page: Kanna.XMLElement) {
        self.init()
        pageId = page["data-content-id"]!
        title = page.text!
        pageUrl = "http://wiki.wanmeizhensuo.com/pages/viewpage.action?pageId=" + pageId
        html = loadHTML()

        // 这个逻辑是模仿wiki页面中的javasript中的已有的逻辑
        if let meta = html?.at_xpath("//meta[@name='confluence-request-time']") {
            lastFetchTime = meta["content"]!
        } else {
            lastFetchTime = String(Int(Date().timeIntervalSince1970 * 1000))
        }

        // 核心是得到developers，其它都是错误处理

        if let developersHtml = html?.xpath("//*[@id=\"main-content\"]/div[1]/div/table/tbody/tr[2]/td/div/p/a") {
            for developer in developersHtml.makeIterator() {
                if let name = developer["data-username"] {
                    developers.append(name)
                } else {
                    if developer.toHTML != nil {
                        Log.append("\(developer.toHTML!) 没有成功解析")
                    } else {
                        Log.append("\(developer)没有成功解析")
                    }
                }
            }
        }

        // 得到FO
        if let foHtml = html?.at_xpath("//*[@id=\"main-content\"]/div[1]/div/table/tbody/tr[6]/td/div/p/span/a") {
            if let name = foHtml["data-username"] {
                fo = name
            } else {
                if foHtml.toHTML != nil {
                    Log.append("\(foHtml.toHTML!) 没有成功解析")
                } else {
                    Log.append("\(foHtml)没有成功解析")
                }
            }
        }

        // 得到测试人员
        if let users = html?.xpath("//*[@id=\"main-content\"]/div[1]/div/table/tbody/tr[8]/td/div/p/a") {
            for testerHtml in users.makeIterator() {
                if let name = testerHtml["data-username"] {
                    developers.append(name)
                } else {
                    if testerHtml.toHTML != nil {
                        Log.append("\(testerHtml.toHTML!) 没有成功解析")
                    } else {
                        Log.append("\(testerHtml)没有成功解析")
                    }
                }
            }
        }
    }

    func isValide() -> Bool {
        if html == nil {
            Log.append("\(pageUrl) 未正常解析")
            return false
        }

        Log.append("创建Page成功: \(title)")
        return true
    }

    // 下载需求页面，从中得到必要的信息
    func loadHTML() -> HTMLDocument? {
        let url = URL(string: pageUrl)!
        var request = URLRequest(url: url)
        request.httpMethod = "GET"
        var html: HTMLDocument?
        request.sync { (data, response, error) in
            if data == nil {
                html = nil
                return
            }
            guard let htmlString = String(data: data!, encoding: .utf8) else {
                html = nil
                return
            }
            html = try? HTML(html: htmlString, encoding: .utf8)
        }

        return html
    }
}


