//
//  Wiki.swift
//  AutoJira
//
//  Created by wangyang on 2019/2/27.
//  Copyright © 2019 wangyang. All rights reserved.
//

import Foundation
import Kanna

class Story: NSObject {

    var storyKey: String = ""
    var storyId: String = ""
    var summary: String = ""

    convenience init(storyKey: String, storyId: String) {
        self.init()
        self.storyId = storyId
        self.storyKey = storyKey
    }

    /// 创建story
    ///
    /// - Parameter page: Page实例
    /// - Returns: storyKey
    static func createStory(with title: String) -> Story? {
        Log.append("创建story")
        let url = URL(string: "http://wiki.wanmeizhensuo.com/rest/jira-integration/1.0/issues?applicationId=54ed5447-b029-3ef0-b638-681b4647313b")!
        var request = URLRequest(url: url)
        request.httpMethod = "POST"
        request.setValue("application/json", forHTTPHeaderField: "Content-Type")
        let jsonDic = ["issues": [["fields":["project":["id":"10108"],"issuetype":["id":"10001"],"summary": title]]]]
        request.httpBody = try? JSONSerialization.data(withJSONObject: jsonDic, options: [])
        var story: Story?
        request.sync { (data, response, error) in
            if data == nil {
                Log.append(error)
                return
            }
            if let json = (try? JSONSerialization.jsonObject(with: data!, options: JSONSerialization.ReadingOptions.allowFragments)) as? [String: Any],
                let issues = json["issues"] as? [Any],
                let issueInfo = issues[0] as? [String: Any],
                let issue = issueInfo["issue"] as? [String: Any],
                let key = issue["key"] as? String,
                let id = issue["id"] as? String {
                story = Story(storyKey: key, storyId: id)
                story?.summary = title
                Log.append("创建story请求成功：\(story!.storyKey)")
            } else {
                Log.append("创建story请求失败：\n\(response.debugDescription)")
            }
        }
        return story
    }

    /// 关联文档与story
    ///
    /// - Parameter page: Page实例
    func connect(to pageId: String, with pageLastFetchTime: String) {
        Log.append("关联story与wiki")
        let url = URL(string: "http://wiki.wanmeizhensuo.com/rest/highlighting/1.0/insert-storage-fragment")!
        var request = URLRequest(url: url)
        request.httpMethod = "POST"
        request.setValue("application/json", forHTTPHeaderField: "Content-Type")
        let bodyString = "{\"pageId\":\"\(pageId)\",\"selectedText\":\"项目背景\",\"index\":0,\"numMatches\":1,\"lastFetchTime\":\(pageLastFetchTime),\"xmlModification\":\"<ac:macro ac:name='jira'><ac:parameter ac:name='showSummary'>false</ac:parameter><ac:parameter ac:name='server'>JIRA</ac:parameter><ac:parameter ac:name='serverId'>54ed5447-b029-3ef0-b638-681b4647313b</ac:parameter><ac:parameter ac:name='key'>\(storyKey)</ac:parameter></ac:macro>\"}"
        let data = bodyString.data(using: .utf8)
        request.httpBody = data

        request.sync { (data, response, error) in
            if error != nil {
                Log.append(error)
                return
            }
            if let json = (try? JSONSerialization.jsonObject(with: data!, options: JSONSerialization.ReadingOptions.allowFragments)) as? Bool {
                if json {
                    Log.append("关联story与wiki成功")
                } else {
                    Log.append("关联story与wiki失败，很有可能是文档中没有\"项目背景\"四个字。response：\n \(response.debugDescription)")
                }
                return
            } else {
                Log.append("关联story与wiki失败，json没有正常解析。response：\n \(response.debugDescription)")
            }
        }
    }


    /// 修改story的“指派人”
    /// 修改story所在的sprint
    /// - Parameter page: page实例
    func editStoryInfo(assignee: String) {
        Log.append("编辑story的assign与sprint")
        // assign
        // sprint
        let url = URL(string: "http://jira.wanmeizhensuo.com/secure/QuickEditIssue.jspa?issueId=\(storyId)&decorator=none")!
        var request = URLRequest(url: url)
        request.httpMethod = "POST"
        request.setValue("application/x-www-form-urlencoded", forHTTPHeaderField: "Content-Type")

        guard let formString = getEditIssueFormdata(assignee: assignee) else {
            Log.append("editStoryInfo 失败")
            return
        }

        let formData = formString.data(using: .utf8)
        request.httpBody = formData
        request.sync { (data, response, error) in
            if error != nil {
                Log.append(error)
            } else {
                Log.append("修改issue成功")
            }
        }
    }

    func getEditIssueFormdata(assignee: String) -> String? {
        let url = URL(string: "http://jira.wanmeizhensuo.com/secure/QuickEditIssue!default.jspa?issueId=\(self.storyId)&decorator=none")!
        var request = URLRequest(url: url)
        request.httpMethod = "POST"
        var json: [String: Any]?
        request.sync { (data, response, error) in
            if data == nil {
                Log.append(error)
                return
            }
            json = (try? JSONSerialization.jsonObject(with: data!, options: JSONSerialization.ReadingOptions.allowFragments)) as? [String: Any]
        }

        if json == nil {
            Log.append("secure/QuickEditIssue出错")
            return nil
        }

        guard let formToken = json!["formToken"] else {
            Log.append("formToken出错")
            return nil
        }

        guard let atl_token = json!["atl_token"] else {
            Log.append("atl_token出错")
            return nil
        }

        // sprint: ustomfield_10005
        // assignee

        //        let formData = "id=\(self.storyId)&atl_token=\(atl_token)&formToken=\(formToken)&summary=%E9%83%A8%E5%88%86%E9%A1%B5%E9%9D%A2%E5%8F%AA%E5%85%81%E8%AE%B8%E5%8F%AA%E5%BC%B9%E5%87%BA%E4%B8%80%E6%AC%A1&timetracking_originalestimate=&isCreateIssue=&hasWorkStarted=&issuetype=10001&assignee=wangyang&reporter=wangyang&customfield_10102=ceshi&description=&priority=3&issuelinks=issuelinks&issuelinks-linktype=blocks&customfield_10005=264&customfield_10103=&dnd-dropzone=&timetracking_remainingestimate=&worklog_timeLogged=&worklog_startDate=08%2FMar%2F19+4%3A40+PM&worklog_adjustEstimate=auto&isCreateIssue=false&isEditIssue=true&comment=&commentLevel="

        let formData = "id=\(storyId)&atl_token=\(atl_token)&formToken=\(formToken)&assignee=\(assignee)&customfield_10005=\(RepeatedWork.sprint!.id)&isCreateIssue=false&isEditIssue=true&summary=\(summary)&issuetype=10001&reporter=wangyang"
        return formData
    }


    /// 根据story创建每一个人的subtask
    ///
    /// - Parameter page: page实例
    static func createSubtask(page: Page) {
        Log.append("根据story创建subtask")
    }
}
