#!/usr/bin/ruby
# encoding: UTF-8
require 'mail'
require 'dingbot'
require File.dirname(__FILE__) + '/Confluence'
require File.dirname(__FILE__) + '/ding'

# 类似于“7.11开发”这样的事件名，用于对比记录邮件是否已经发送
$dev_title = ""
# 类似于“7.11客户端提交”这样的事件名，用于稍后发邮件
$submit_title = ""
# 类似于“7.11客户端提交”这样的事件的时间，用于稍后发邮件
$submit_date = ""
# 用来存储全局变量$dev_title的文件名
STORE_KEY = "sprintEmailHistory.log"

# 返回值：Deliver
def get_submit_info
    # 客户端提交时间
    submit_event_id = "e1c8aef8-130e-40bf-8f6c-fe0e5c5dbd9c" 
    events = get_events(submit_event_id)
    # 发版时间大于今天，则是这个版本的发版时间
    for event in events
        deploy_date = Date.parse(event.start)
        if deploy_date > today
            $submit_title = event.title
            $submit_date = deploy_date
            break
        end
    end
end

def get_store_value(key)
    # sprintEmailHistory.log
    filePath = File.dirname(__FILE__) + '/' + key
    file = File.open(filePath, "a+", external_encoding: Encoding::UTF_8, internal_encoding: Encoding::UTF_8)
    return file.read()
end

def set_store_value(key, value)
    filePath = File.dirname(__FILE__) + '/' + key
    file = File.open(filePath, "a+", external_encoding: Encoding::UTF_8, internal_encoding: Encoding::UTF_8)
    file.truncate(0)
    count = file.write(value)
end

# 如果今天是开发第一天，并且之前没有发送过，则允许发送邮件
def should_send_email_today
    # 开始开发的时间
    dev_event_id = "3bcd7d25-37d0-4624-83d2-691c456a76a8"
    events = get_events(dev_event_id)
    # 读取历史记录，如果以前发送过，则不需要再次发送
    history = get_store_value(STORE_KEY)
    puts "history #{history}"

    for event in events 
        start = Date.parse(event.start)

        if start == today 
            if history == event.title
                puts "#{event.title} 版本已经发过邮件"
                return false
            else
                puts "dev_title #{$dev_title}, event_title #{event.title}"
                $dev_title = event.title
                puts "可以发送邮件"
                return true
            end
        end
    end
    puts "今天不是发送邮件的日子"
    return false
end


def send_email()
    mail = Mail.defaults do
      delivery_method :smtp, {
        :port      => 465,
        :address   => "smtp.exmail.qq.com",
        :user_name => "jaguar@igengmei.com",
        :password  => "Jaguar@131415",
        :enable_starttls_auto => false, 
        :openssl_verify_mode => 'none',
        :authentication => :plain,
        :ssl => true    
      }
    end

    mail = Mail.deliver do
        # 其实下面都是方法调用，不要被迷惑了
        to ['hualu@igengmei.com', 'wangjun@igengmei.com', 'huchunhe@igengmei.com', 'SJ-liuxiao@igengmei.com', 'jishu@igengmei.com', 'wanghongying@igengmei.com', 'product@igengmei.com', 'sheji@igengmei.com']
        #to      ['jaguar@igengmei.com']
        bcc     'jaguar@igengmei.com' # 抄送
        from    'jaguar@igengmei.com' # 发件人
        subject "更美app#{$submit_title}商店物料信息"
  
        text_part do
            content_type "text/plain; charset=utf-8"
            body <<~EOF
                Hi，All
            
                #{$submit_title}时间为#{$submit_date.to_s}，请准备商店相关的物料信息（是否更换APP icon和商店海报），谢谢~
            EOF
          end
    end

end

# 测试 email_body 是否符合预期
def test_email_body()
    puts <<~EOF
        Hi，All
            
        #{$submit_title}时间为#{$submit_date.to_s}，请准备商店相关的物料信息（是否更换APP icon和商店海报），谢谢~
    EOF
end

def notify_release_date_by_email()
    if should_send_email_today
        get_submit_info
        begin
            if $DEBUG
                test_email_body
            else
                send_email
            end

            # 邮件发送成功后，再存储数据 
            set_store_value(STORE_KEY, $dev_title)

            puts "邮件已发送"
        rescue Exception => e
            puts "邮件发送失败"
            puts e.message
            
            # 客户端组
            bot_id = "8142e051fe21d101b7e619c179741b0502f99b66ede221e164c2c1643122378d"
            ding_at_me(bot_id,
                "sprintEmail 迭代发版时间邮件发送失败.\n#{e.message}")
        end 
    end
end
