#! /bin/ruby
require 'httparty'
require 'json'
require "ostruct"
require 'net/smtp'
require 'mail'

def login 
    # 登录
    options = { 
        :body => {:os_username => "wangyang", :os_password => 'wind1988wind', :login => '%E7%99%BB%E5%BD%95' }, 
        :headers => {  
            'Content-Type' => 'application/x-www-form-urlencoded', 
            'Accept' => 'application/json, text/javascript, */*; q=0.01'
            }
        }
    login = HTTParty.post("http://wiki.wanmeizhensuo.com/dologin.action", options)
    # puts login.to_s
    $cookie = login.headers['set-cookie']
end

def today 
    return Date.parse("2019-02-27")
    # return Date.today
end

def dev_start_time 
    return today << 1
end

def dev_end_time 
    return today >> 1
end

def get_event
    event_headers = {
        :headers => {  
            'Cookie' => $cookie, 
            'Accept' => 'application/json, text/javascript, */*; q=0.01'
        },
    }
    dev_event_id = "3bcd7d25-37d0-4624-83d2-691c456a76a8"
    event_query = "subCalendarId=#{dev_event_id}&userTimeZoneId=Asia%2FShanghai&start=#{dev_start_time}T00%3A00%3A00Z&end=#{dev_end_time}T00%3A00%3A00Z&_=1552802345400"
    events = HTTParty.get("http://wiki.wanmeizhensuo.com/rest/calendar-services/1.0/calendar/events.json?#{event_query}", event_headers)
end

class Deliver 
    attr_accessor :title
    attr_accessor :date
    def initialize(title, date)
        @title = title
        @date = date
    end

end


# 参数：版本号
# 返回值：发版时间
# 开发的第三的时间，与发版时间肯定有先后顺序
def get_deliver_info
    event_headers = {
        :headers => {  
            'Cookie' => $cookie, 
            'Accept' => 'application/json, text/javascript, */*; q=0.01'
        },
    }
    # 以后端上线时间为准，保证程序员不被其它工作量压到下一个迭代的开发周
    # dev_event_id = "e1c8aef8-130e-40bf-8f6c-fe0e5c5dbd9c" # 提交时间
    backend_deploy_event_id = "8389fda3-a06c-49b5-af85-788c4af12071" # 后端上线时间
    event_query = "subCalendarId=#{backend_deploy_event_id}&userTimeZoneId=Asia%2FShanghai&start=#{dev_start_time}T00%3A00%3A00Z&end=#{dev_end_time}T00%3A00%3A00Z&_=1552802345400"
    events = HTTParty.get("http://wiki.wanmeizhensuo.com/rest/calendar-services/1.0/calendar/events.json?#{event_query}", event_headers)
    obj = JSON.parse(events.body, object_class: OpenStruct)
    for event in obj.events
        deploy_date = Date.parse(event.start)
        if deploy_date > today
            return Deliver.new(event.title, deploy_date)
        end
    end
end

def should_send_email_today
    events = get_event
    # events.body 这样就得到了body string
    # 用OpenStruct就直接生成了一个类
    # ruby是动态语言
    obj = JSON.parse(events.body, object_class: OpenStruct)
    for event in obj.events 
        start = Date.parse(event.start)
        if start == today
            return true
        end
    end

    return false
end


def send_email(deliver_info)
    mail = Mail.defaults do
      delivery_method :smtp, {
        :port      => 465,
        :address   => "smtp.exmail.qq.com",
        :user_name => "wangyang@igengmei.com",
        :password  => "UkZqL94RvD48htFM",
        :enable_starttls_auto => false, 
        :openssl_verify_mode => 'none',
        :authentication => :plain,
        :ssl => true    
      }
    end

    mail_subject = "更美app#{deliver_info.title}版本商店物料信息"
    mail_body = "Hi，All，#{deliver_info.title}时间为#{deliver_info.date.to_s}，请准备商店相关的物料信息（是否更换APP icon和商店海报），谢谢~"
    mail = Mail.deliver do
        # 其实下面都是方法调用，不要被迷惑了
        # to ['dujuan@igengmei.com', 'hualu@igengmei.com', 'wangjun@igengmei.com', 'lizhen@igengmei.com', 'sunwenhui@igengmei.com', 'tanchenshuai@igengmei.com', 'zhucuicui@igengmei.com', 'huchunhe@igengmei.com', 'dongqiang@igengmei.com', 'SJ-liuxiao@igengmei.com']
        to      ['igiu_1988@126.com']
        from    'wangyang@igengmei.com'
        subject mail_subject
        body    mail_body
    end

end

login
if should_send_email_today
    deliver = get_deliver_info
    send_email deliver
    # puts "发送邮件"
end
