#!/usr/bin/ruby
require_rel 'ding'

# 提前通知要过可行；当天也会提示
def ke_xing_notify()
    ke_xing_event_id = "2c8733f7-938d-41e4-9706-ea01bf88ba91"
    events = get_events(ke_xing_event_id)
    for event in events 
        start = Date.parse(event.start)
        # 还剩几天
        days_left = (start - today).to_i
        # cweek是日期所在的周数，所以cweek_offset则是两个时间所差周数
        cweek_offset = start.cweek - today.cweek

        # 只提前一天提示，要考虑跨周末的情况
        if cweek_offset == 1
            if days_left == 3
                # 下周X
                msg = "#{event.title}时间为下周一"
                ding_msg(msg)
            end
        elsif cweek_offset == 0
            if days_left == 1
                msg = "明天#{event.title}"
                ding_msg(msg)
            end
        end
        if days_left == 0
            ding_msg("今天可行")
        end
    end
end

# 提交审核那一天，通知迭代负责人预订会议室
def notify_to_book_ke_xing_meeting_room()
    submit_event_id = "b065a064-5851-4722-931b-7e932257ef54"
    events = get_events(submit_event_id)

    for event in events 
        start = Date.parse(event.start)
        days_left = (start - today).to_i
        cweek_offset = start.cweek - today.cweek
        if start == today
            ding_at_me(KEXING_BOT, "预订下一个迭代可行的会议室")
        end
    end
end

# PMs-更美 app 大迭代    
PM_BOT = "7f105786f654bac5491b5ad808d24521e6fec5d8da8f8b6b7590c16a91a1c4fd"
# 更美大迭代技术可行小组
KEXING_BOT = "6565866a84fe1e879c06273d434152bfd7669d93153780ca34ec2792e0386c1c"

def ding_msg(msg)
    puts msg
    ding_text(PM_BOT, msg)
    ding_text(KEXING_BOT, msg)
end

