#! /Users/wangyang/.rvm/rubies/ruby-2.3.1/bin/ruby
require 'httparty'
require "ostruct"
require 'mail'
require 'dingbot'
require File.dirname(__FILE__) + '/Confluence'

# 提前通知要过可行；当天也会提示
def ke_xing_notify()
    ke_xing_event_id = "2c8733f7-938d-41e4-9706-ea01bf88ba91"
    events = get_events(ke_xing_event_id)

    for event in events 
        start = Date.parse(event.start)
        puts event.title

        days_left = (start - today).to_i
        cweek_offset = start.cweek - today.cweek

        # 只提前一天提示，要考虑跨周末的情况
        if cweek_offset == 1
            if days_left == 3
                # 下周X
                msg = "#{event.title}时间为下周一"
                ding_msg(msg)
            end
        elsif cweek_offset == 0
            if days_left == 1
                msg = "明天#{event.title}"
                ding_msg(msg)
            end
        end
        if days_left == 0
            ding_msg("今天可行")
        end
    end
end

# 提交审核那一天，通知迭代负责人预订会议室
def notify_to_book_ke_xing_meeting_room()
    submit_event_id = "b065a064-5851-4722-931b-7e932257ef54"
    events = get_events(submit_event_id)

    for event in events 
        start = Date.parse(event.start)
        days_left = (start - today).to_i
        cweek_offset = start.cweek - today.cweek
        if start == today
            ding_meeting_book
        end
    end
end

PM_BOT = "7f105786f654bac5491b5ad808d24521e6fec5d8da8f8b6b7590c16a91a1c4fd"
KEXING_BOT = "6565866a84fe1e879c06273d434152bfd7669d93153780ca34ec2792e0386c1c"
TEST_BOT = "0e53adfed496676b49931ab73092ce6dc206ced89fb66852be0906b5e3dcfa75"

def ding_msg(msg)
    # ding(PM_BOT, msg)
    # ding(KEXING_BOT, msg)
    ding(TEST_BOT, msg)
end

def ding(bot_id, msg)
    puts msg
    DingBot.endpoint = 'https://oapi.dingtalk.com/robot/send'
    DingBot.access_token = bot_id
    message = DingBot::Message::Text.new(
      "#{msg}",
      [],
      false
    )
    DingBot.send_msg(message)  
end

def ding_meeting_book
    DingBot.endpoint = 'https://oapi.dingtalk.com/robot/send'
    DingBot.access_token = KEXING_BOT
    message = DingBot::Message::Text.new(
      "预订下一个迭代可行的会议室",
      ["15811315780"],
      false
    )
    DingBot.send_msg(message)  
end


login
ke_xing_notify
notify_to_book_ke_xing_meeting_room
