#!/usr/bin/ruby
# encoding: UTF-8
require 'httparty'
require "ostruct"
require 'mail'
require 'dingbot'

=begin
知识点：网络请求库 HTTParty
gem HTTParty 一个现成的网络请求，用法简单到有些奇怪。当然也可以用ruby原生的请求方法，只是很繁琐

知识点：JSON转模型，ostruct
gem ostruct 提供了一行代码将json string转模型的能力
例如：obj = JSON.parse(json_string, object_class: OpenStruct)
就直接得到了模型。注意OpenStruct为固定写法，不需要改变

知识点：JSON解析
gem json 提供了JSON解析
类如：JSON.parse(json_string)，就可以将这段string转为相应的模型

知识点：发送邮件
gem mail 提供了邮件能力。具体见send_email方法的实现
=end

# TODO: 将登录帐号及邮箱换成只在内网使用的，比如jaguar
def login 
    # 登录
    options = { 
        :body => {:os_username => "wangyang", :os_password => 'wind1988wind', :login => '%E7%99%BB%E5%BD%95' }, 
        :headers => {  
            'Content-Type' => 'application/x-www-form-urlencoded', 
            'Accept' => 'application/json, text/javascript, */*; q=0.01'
            }
        }
    login = HTTParty.post("http://wiki.wanmeizhensuo.com/dologin.action", options)
    # puts login.to_s
    cookie = login.headers['set-cookie']
    $event_headers = {
        :headers => {  
            'Cookie' => cookie, 
            'Accept' => 'application/json, text/javascript, */*; q=0.01'
        },
    }
end

def today 
    # 打开下面注释，改成某个版本开始时间，就可以调试这个版本的发邮件服务了
    # return Date.parse("2019-06-20")
    return Date.today
end

def dev_start_time 
    return today << 1
end

def dev_end_time 
    return today >> 1
end

def get_dev_events_response
    dev_event_id = "3bcd7d25-37d0-4624-83d2-691c456a76a8"
    event_query = "subCalendarId=#{dev_event_id}&userTimeZoneId=Asia%2FShanghai&start=#{dev_start_time}T00%3A00%3A00Z&end=#{dev_end_time}T00%3A00%3A00Z&_=1552802345400"
    events = HTTParty.get("http://wiki.wanmeizhensuo.com/rest/calendar-services/1.0/calendar/events.json?#{event_query}", $event_headers)
end

class Deliver 
    attr_accessor :title
    attr_accessor :date
    def initialize(title, date)
        @title = title
        @date = date
    end
end

# 返回值：Deliver
def get_deliver_info
    # 以后端上线时间为准，保证程序员不被其它工作量压到下一个迭代的开发周
    dev_event_id = "e1c8aef8-130e-40bf-8f6c-fe0e5c5dbd9c" # 提交时间
    # backend_deploy_event_id = "8389fda3-a06c-49b5-af85-788c4af12071" # 后端上线时间
    event_query = "subCalendarId=#{dev_event_id}&userTimeZoneId=Asia%2FShanghai&start=#{dev_start_time}T00%3A00%3A00Z&end=#{dev_end_time}T00%3A00%3A00Z&_=1552802345400"
    events = HTTParty.get("http://wiki.wanmeizhensuo.com/rest/calendar-services/1.0/calendar/events.json?#{event_query}", $event_headers)
    obj = JSON.parse(events.body, object_class: OpenStruct)
    # 发版时间大于今天，则是这个版本的发版时间
    for event in obj.events
        deploy_date = Date.parse(event.start)
        if deploy_date > today
            return Deliver.new(event.title, deploy_date)
        end
    end
end

def should_send_email_today
    response = get_dev_events_response
    obj = JSON.parse(response.body, object_class: OpenStruct)
    # 读取历史记录，如果以前发送过，则不需要再次发送
    filePath = File.dirname(__FILE__) + '/sprintEmailHistory.log'
    file = File.open(filePath, "a+", external_encoding: Encoding::UTF_8, internal_encoding: Encoding::UTF_8)
    history = file.read()
    puts "history #{history}"

    for event in obj.events 
        puts "#{event.title} #{event.start}"
        start = Date.parse(event.start)

        if start == today 
            if history == event.title
                puts "#{event.title} 版本已经发过邮件"
                return false
            else
                file.truncate(0)
                count = file.write(event.title)
                file.close
                puts "可以发送邮件"
                return true
            end
        end
    end
    puts "今天不是发送邮件的日子"
    return false
end


def send_email(deliver_info)
    mail = Mail.defaults do
      delivery_method :smtp, {
        :port      => 465,
        :address   => "smtp.exmail.qq.com",
        :user_name => "jaguar@igengmei.com",
        :password  => "Jaguar@131415",
        :enable_starttls_auto => false, 
        :openssl_verify_mode => 'none',
        :authentication => :plain,
        :ssl => true    
      }
    end

    mail = Mail.deliver do
        # 其实下面都是方法调用，不要被迷惑了
        to ['hualu@igengmei.com', 'wangjun@igengmei.com', 'sunwenhui@igengmei.com', 'tanchenshuai@igengmei.com', 'zhucuicui@igengmei.com', 'huchunhe@igengmei.com', 'dongqiang@igengmei.com', 'SJ-liuxiao@igengmei.com', 'client-rd@igengmei.com']
        # to      ['jaguar@igengmei.com']
        bcc     'jaguar@igengmei.com' # 抄送
        from    'jaguar@igengmei.com' # 发件人
        subject "更美app#{deliver_info.title}商店物料信息"
  
        text_part do
            content_type "text/plain; charset=utf-8"
            body <<-EOF
Hi，All
            
#{deliver_info.title}时间为#{deliver_info.date.to_s}，请准备商店相关的物料信息（是否更换APP icon和商店海报），谢谢~
            EOF
          end
    end

end

login
if should_send_email_today
    deliver = get_deliver_info
    begin
        send_email deliver
        puts "邮件已发送"
    rescue Exception => e
        puts e.message
        
        DingBot.endpoint = 'https://oapi.dingtalk.com/robot/send'
        DingBot.access_token = '8142e051fe21d101b7e619c179741b0502f99b66ede221e164c2c1643122378d'
        message = DingBot::Message::Text.new(
          'sprintEmail 迭代发版时间邮件发送失败',
          ['15811315780'],
          false
        )
        DingBot.send_msg(message)   
    end 
end
