/*
 * @author lsy
 * @date   2019-11-01
 **/
import 'dart:io';

import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_drag_scale/core/drag_scale_widget.dart';
import 'package:gmalpha_flutter/AlbumModel/page/preview/AlbumPreviewModel.dart';
import 'package:gmalpha_flutter/commonModel/base/BaseComponent.dart';

class AlbumPreviewPage extends StatefulWidget {
  AlbumPreviewModel _model;
  String fromPage;

  AlbumPreviewPage(String imgPath, int size, this.fromPage) {
    _model = AlbumPreviewModel(imgPath,size);
  }

  @override
  State<StatefulWidget> createState() => AlbumPreviewState(_model, fromPage);
}

class AlbumPreviewState extends State<AlbumPreviewPage> {
  AlbumPreviewModel _model;
  final String fromPage;

  AlbumPreviewState(this._model, this.fromPage);

  @override
  void initState() {
    super.initState();
    _model.getPreviewImage(context);
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
        onWillPop: () {
          Navigator.pop(context);
        },
        child: Scaffold(
            appBar: baseAppBar(backClick: () {
              Navigator.pop(context);
            }),
            body: Container(
                alignment: Alignment.center,
                width: double.maxFinite,
                height: double.maxFinite,
                child: StreamBuilder(
                    stream: _model.imageLive.stream,
                    initialData: _model.imageLive.data,
                    builder: ((con, data) {
                      if (data.data == null) {
                        return loadingItem();
                      }
                      return DragScaleContainer(
                          doubleTapStillScale: false,
                          child: new Image.file(
                            File(
                              _model.imgPath,
                            ),
                            fit: BoxFit.fitWidth,
                          ));
                    })))));
  }

  @override
  void dispose() {
    _model.dispose();
    super.dispose();
  }
//  @override
//  String pageName() {
//    return "album_preview";
//  }
//
//  @override
//  String referrer() {
//    return fromPage;
//  }
}
