/*
 * @author lsy
 * @date   2019-09-30
 **/
import 'package:gmalpha_flutter/BuriedLib/buried/SendTask.dart';
import 'package:gmalpha_flutter/BuriedLib/proto/burying.pbgrpc.dart';

const BURIED_TAG = "BURIED";

class BuriedCenter {
  static SendTask sendTask;

  static BuriedCenter _instance;

  BuriedCenter._() {
    sendTask = new SendTask();
  }

  static BuriedCenter getInstance() {
    if (_instance == null) {
      _instance = BuriedCenter._();
    }
    return _instance;
  }

  void onPageEnd(String page_name, String inPage, String outPage,
      {String fake,
      String business_id,
      String referrer,
      String referrer_id,
      String extra_param,
      String referrer_tab_name,
      String isPush}) {
    if (page_name == null) {
      print("$BURIED_TAG onPageStart page_name is null");
    }
    var normalRequest = BuryingRequest.create();
    normalRequest.type = "page_view";
    normalRequest.params["in"] = inPage ?? "";
    normalRequest.params["out"] = outPage ?? "";
    normalRequest.params["page_name"] = page_name ?? "";
    normalRequest.params["business_id"] = business_id ?? "";
    normalRequest.params["referrer"] = referrer ?? "";
    normalRequest.params["referrer_id"] = referrer_id ?? "";
    normalRequest.params["extra_param"] = extra_param ?? "";
    normalRequest.params["referrer_tab_name"] = referrer_tab_name ?? "";
    normalRequest.params["isPush"] = isPush ?? "";
    sendTask.sendBuried(normalRequest);
  }

  void onEvent(String type, Map<String, String> params) {
    var normalRequest = BuryingRequest.create();
    normalRequest.type = type;
    if (params != null) {
      normalRequest.params.addAll(params);
    }
    sendTask.sendBuried(normalRequest);
  }
}
