import 'package:flutter/cupertino.dart';
import 'package:gmalpha_flutter/FindModel/service/FindRepository.dart';
import 'package:gmalpha_flutter/FindModel/service/remote/entity/FindEntity.dart';
import 'package:gmalpha_flutter/commonModel/live/BaseModel.dart';
import 'package:gmalpha_flutter/commonModel/live/LiveData.dart';
import 'package:gmalpha_flutter/commonModel/toast/toast.dart';

class FindModel extends BaseModel{
  final int page;
  final int count;
  LiveData<FindEntity> findLive = new LiveData();
  FindEntity findList;

  FindModel(this.page, this.count);
  
  init(BuildContext context,[callback=null]){
    getFindPage(page,count,callback);
  }

  getFindPage(page,count,[callback]){
    FindRepository.getInstance()
    .getFindPage(page, count)
    .listen((value){
      if (value != null) {
        if(page > 1) {
          findList.data?.cards?.addAll(value.data.cards);
        } else {
          findList = value;
        }
        if(callback != null) callback(value);
        findLive.notifyView(findList);
      }
    }).onError((error) {
      Toast.show(error, "${error.toString()}");
      print(error);
    });
  }
  @override
  void dispose() {
    findLive.dispost();
  }
  
}