class FindEntity {
  int error;
  String message;
  Null extra;
  Data data;

  FindEntity({this.error, this.message, this.extra, this.data});

  FindEntity.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    extra = json['extra'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['extra'] = this.extra;
    if (this.data != null) {
      data['data'] = this.data.toJson();
    }
    return data;
  }
}

class Data {
  List<Cards> cards;

  Data({this.cards});

  Data.fromJson(Map<String, dynamic> json) {
    if (json['cards'] != null) {
      cards = new List<Cards>();
      json['cards'].forEach((v) {
        cards.add(new Cards.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.cards != null) {
      data['cards'] = this.cards.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Cards {
  List<Topics> topics;
  int layout;

  Cards({this.topics, this.layout});

  Cards.fromJson(Map<String, dynamic> json) {
    if (json['topics'] != null) {
      topics = new List<Topics>();
      json['topics'].forEach((v) {
        topics.add(new Topics.fromJson(v));
      });
    }
    layout = json['layout'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.topics != null) {
      data['topics'] = this.topics.map((v) => v.toJson()).toList();
    }
    data['layout'] = this.layout;
    return data;
  }
}

class Topics {
  int topicId;
  String imageUrl;
  int imageId;

  Topics({this.topicId, this.imageUrl, this.imageId});

  Topics.fromJson(Map<String, dynamic> json) {
    topicId = json['topic_id'];
    imageUrl = json['image_url'];
    imageId = json['image_id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['topic_id'] = this.topicId;
    data['image_url'] = this.imageUrl;
    data['image_id'] = this.imageId;
    return data;
  }
}