import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:gmalpha_flutter/MessageModel/service/remote/entity/AttentionEntity.dart';
import 'package:gmalpha_flutter/MessageModel/util/message_date.dart';
import 'package:gmalpha_flutter/commonModel/GMBase.dart';
import 'package:gmalpha_flutter/res/value/ALColors.dart';

class AttentionListItem extends StatelessWidget {
  final Data item;

  AttentionListItem(this.item);

  Text myText(String text, Color color, double size,
      {int maxLines = 1, bool weight = false}) {
    return Text(
      text,
      softWrap: true,
      maxLines: maxLines,
      overflow: TextOverflow.ellipsis,
      style: TextStyle(
        fontSize: ScreenUtil.instance.setSp(size),
        color: color,
        height: 1.38,
        fontWeight: weight ? FontWeight.bold : FontWeight.normal
      ),
    );
  }

  Widget listItemHead() {
    return ClipOval(
        child: Container(
      color: ALColors.ColorE4E4E4,
      child: CachedNetworkImage(
        width: 42.0,
        height: 42.0,
        imageUrl: item.icon,
        fit: BoxFit.cover,
      ),
    ));
  }

  Widget listItemInfo() {
    return Expanded(
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: <Widget>[
          Container(
            margin: EdgeInsets.only(left: ScreenUtil.instance.setWidth(10.0)),
            child: myText('${item.title}', ALColors.Color464646, 13.0, weight: true),
          ),
          Padding(
            padding: EdgeInsets.only(left: ScreenUtil.instance.setWidth(10.0), top: ScreenUtil.instance.setHeight(4.0)),
            child: myText('${item.content}', ALColors.Color666666, 13.0, maxLines: 2),
          ),
          Padding(
            padding: EdgeInsets.only(left: ScreenUtil.instance.setWidth(10.0), top: ScreenUtil.instance.setHeight(3.0)),
            child: myText(MessageDate(item.pushTime).diffTime(), ALColors.Color999999, 10.0)
          )
        ],
      ),
    );
  }

  Widget listItemButton() {
    return Container(
      padding: EdgeInsets.only(top: ScreenUtil.instance.setHeight(5.0), left: ScreenUtil.instance.setWidth(12.0)),
      width: ScreenUtil.instance.setWidth(66.0),
      height: ScreenUtil.instance.setHeight(34.0),
      child: OutlineButton(
          padding: const EdgeInsets.only(
            left: 0.0,
            right: 0.0,
          ),
          borderSide: BorderSide(color: ALColors.Color323232),
          shape: RoundedRectangleBorder(borderRadius: BorderRadius.zero),
          onPressed: () {
            jumpToNative('url_page', {"url": item.url});
          },
          child: myText('详情', ALColors.Color323232, 13.0)),
    );
  }

  @override
  Widget build(BuildContext context) {
    ScreenUtil.instance = ScreenUtil(width: 375.0, height: 667.0, allowFontScaling: true)..init(context);
    return Container(
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: <Widget>[listItemHead(), listItemInfo(), listItemButton()],
      ),
    );
  }
}
